/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.threetag.palladium.accessory.AccessoryPlayerData;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.ToolHandsAbility;
import net.threetag.palladiumcore.util.PlayerUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements PalladiumPlayerExtension {
    @Unique
    private FlightHandler palladium$flightHandler;
    @Unique
    private AccessoryPlayerData palladium$accessories;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void init(Level level, BlockPos blockPos, float yRot, GameProfile gameProfile, CallbackInfo ci) {
        this.palladium$getFlightHandler();
        this.palladium$accessories = new AccessoryPlayerData();
        PlayerUtil.refreshDisplayName((Player)((Player)this));
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        this.palladium$flightHandler.tick();
    }

    @ModifyVariable(method={"getDimensions"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private Pose getDimensions(Pose pose) {
        float hover = this.palladium$flightHandler.getHoveringAnimation(0.0f);
        float levitation = this.palladium$flightHandler.getLevitationAnimation(0.0f);
        float flight = this.palladium$flightHandler.getFlightAnimation(0.0f);
        if (hover > 0.0f || levitation > 0.0f || flight > 0.0f) {
            if (this.palladium$flightHandler.flightBoost > 1.0f) {
                return Pose.FALL_FLYING;
            }
            return Pose.STANDING;
        }
        return pose;
    }

    @ModifyVariable(method={"getStandingEyeHeight"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private Pose getStandingEyeHeight(Pose pose) {
        float hover = this.palladium$getFlightHandler().getHoveringAnimation(0.0f);
        float levitation = this.palladium$getFlightHandler().getLevitationAnimation(0.0f);
        float flight = this.palladium$getFlightHandler().getFlightAnimation(0.0f);
        if (hover > 0.0f || levitation > 0.0f || flight > 0.0f) {
            if (this.palladium$getFlightHandler().flightBoost > 1.0f) {
                return Pose.FALL_FLYING;
            }
            return Pose.STANDING;
        }
        return pose;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    public void readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        CompoundTag palladiumTag;
        CompoundTag compoundTag = palladiumTag = compound.m_128441_("Palladium") ? compound.m_128469_("Palladium") : new CompoundTag();
        if (palladiumTag.m_128425_("Accessories", 10)) {
            this.palladium$accessories.fromNBT(palladiumTag.m_128469_("Accessories"));
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    public void addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        CompoundTag palladiumTag = compound.m_128441_("Palladium") ? compound.m_128469_("Palladium") : new CompoundTag();
        palladiumTag.m_128365_("Accessories", (Tag)this.palladium$accessories.toNBT());
        compound.m_128365_("Palladium", (Tag)palladiumTag);
    }

    @Inject(method={"hasCorrectToolForDrops"}, at={@At(value="RETURN")}, cancellable=true)
    public void palladium$hasCorrectToolForDrops(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            AbilityUtil.getEnabledInstances((LivingEntity)this, (Ability)Abilities.TOOL_HANDS.get()).forEach(abilityInstance -> {
                if (ToolHandsAbility.blockDrops(abilityInstance, state)) {
                    cir.setReturnValue((Object)true);
                }
            });
        }
    }

    @Override
    public FlightHandler palladium$getFlightHandler() {
        if (this.palladium$flightHandler == null) {
            this.palladium$flightHandler = new FlightHandler((Player)this);
        }
        return this.palladium$flightHandler;
    }

    @Override
    public AccessoryPlayerData palladium$getAccessories() {
        return this.palladium$accessories;
    }
}

