/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin;

import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.script.ScriptFile;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptPackInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import net.threetag.palladium.addonpack.AddonPackManager;
import net.threetag.palladium.compat.kubejs.AddonPackScriptFileInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ScriptManager.class})
public class ScriptManagerMixin {
    @Shadow(remap=false)
    @Final
    public Map<String, ScriptPack> packs;
    @Shadow(remap=false)
    @Final
    public ScriptType scriptType;

    @Inject(at={@At(value="RETURN")}, method={"loadFromDirectory"}, remap=false)
    public void loadFromDirectory(CallbackInfo ci) {
        AddonPackManager.getInstance().getPackList().m_10506_();
        AddonPackManager.getInstance().getPackList().m_10509_(AddonPackManager.getInstance().getPackList().m_10514_());
        HashMap scriptFileInfoMap = new HashMap();
        for (Pack pack : AddonPackManager.getInstance().getPackList().m_10519_()) {
            PackType packType = this.scriptType == ScriptType.CLIENT ? PackType.CLIENT_RESOURCES : (this.scriptType == ScriptType.SERVER ? PackType.SERVER_DATA : AddonPackManager.getPackType());
            PackResources packResources = pack.m_10445_();
            for (String namespace : packResources.m_5698_(packType)) {
                packResources.m_8031_(packType, namespace, "kubejs_scripts", (path, inputStreamIoSupplier) -> {
                    if (path.m_135815_().endsWith(".js")) {
                        ((List)scriptFileInfoMap.computeIfAbsent(namespace, s -> Pair.of((Object)new ScriptPackInfo("addonpack_" + s, ""), new ArrayList())).getSecond()).add(new AddonPackScriptFileInfo((ScriptPackInfo)((Pair)scriptFileInfoMap.get(namespace)).getFirst(), path.m_135815_(), () -> {
                            try {
                                PackResources packResources1 = pack.m_10445_();
                                IoSupplier inputStream = packResources1.m_214146_(packType, path);
                                packResources1.close();
                                return (InputStream)inputStream.m_247737_();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                return null;
                            }
                        }));
                    }
                });
            }
            packResources.close();
        }
        for (Map.Entry entry : scriptFileInfoMap.entrySet()) {
            ScriptPack scriptPack = new ScriptPack((ScriptManager)this, (ScriptPackInfo)((Pair)entry.getValue()).getFirst());
            scriptPack.info.scripts.addAll((Collection)((Pair)entry.getValue()).getSecond());
            for (ScriptFileInfo fileInfo : scriptPack.info.scripts) {
                try {
                    fileInfo.preload(null);
                    String skip = fileInfo.skipLoading();
                    if (skip.isEmpty()) {
                        scriptPack.scripts.add(new ScriptFile(scriptPack, fileInfo, null));
                        continue;
                    }
                    this.scriptType.console.info((Object)("Skipped " + fileInfo.location + ": " + skip));
                }
                catch (Throwable error) {
                    this.scriptType.console.error((Object)("Failed to pre-load script file " + fileInfo.location + ": " + String.valueOf(error)));
                }
            }
            scriptPack.scripts.sort(null);
            this.packs.put(scriptPack.info.namespace, scriptPack);
        }
    }
}

