/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.client.renderer.item.armor.ArmorRendererData;
import net.threetag.palladium.compat.geckolib.armor.CancelGeckoArmorBuffer;
import net.threetag.palladium.item.ArmorWithRenderer;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class})
public abstract class HumanoidArmorLayerMixin {
    @Shadow
    protected abstract void m_117125_(HumanoidModel var1, EquipmentSlot var2);

    @Shadow
    protected abstract boolean m_117128_(EquipmentSlot var1);

    @Inject(method={"renderArmorPiece"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource buffer, LivingEntity livingEntity, EquipmentSlot slot, int packedLight, HumanoidModel model, CallbackInfo ci) {
        ArmorWithRenderer armorWithRenderer;
        Item item;
        ItemStack item2 = livingEntity.m_6844_(slot);
        if (!item2.m_41619_() && (item = item2.m_41720_()) instanceof ArmorWithRenderer && (armorWithRenderer = (ArmorWithRenderer)item).hasCustomRenderer()) {
            ci.cancel();
            Object object = armorWithRenderer.getCachedArmorRenderer();
            if (object instanceof ArmorRendererData) {
                ArmorRendererData renderer = (ArmorRendererData)object;
                HumanoidArmorLayer layer = (HumanoidArmorLayer)this;
                ArmorItem armorItem = (ArmorItem)item2.m_41720_();
                if (armorItem.m_40402_() == slot) {
                    DataContext context = DataContext.forArmorInSlot(livingEntity, slot);
                    HumanoidModel<?> overriddenModel = renderer.getModel(livingEntity, context);
                    ResourceLocation armorTexture = renderer.getTexture(context);
                    if (overriddenModel != null) {
                        model = overriddenModel;
                    }
                    ((HumanoidModel)layer.m_117386_()).m_102872_(model);
                    this.m_117125_(model, slot);
                    boolean innerModel = this.m_117128_(slot);
                    boolean foil = item2.m_41790_();
                    if (armorItem instanceof DyeableArmorItem) {
                        ResourceLocation overlayTexture = renderer.getTexture(context, "overlay");
                        int j = ((DyeableArmorItem)armorItem).m_41121_(item2);
                        float f = (float)(j >> 16 & 0xFF) / 255.0f;
                        float g = (float)(j >> 8 & 0xFF) / 255.0f;
                        float h = (float)(j & 0xFF) / 255.0f;
                        this.palladium$renderModelCustom(poseStack, buffer, packedLight, foil, model, armorTexture, innerModel, f, g, h);
                        this.palladium$renderModelCustom(poseStack, buffer, packedLight, foil, model, overlayTexture, innerModel, 1.0f, 1.0f, 1.0f);
                    } else {
                        this.palladium$renderModelCustom(poseStack, buffer, packedLight, foil, model, armorTexture, innerModel, 1.0f, 1.0f, 1.0f);
                    }
                }
            }
            ci.cancel();
        }
    }

    @Unique
    private void palladium$renderModelCustom(PoseStack poseStack, MultiBufferSource buffer, int packedLight, boolean foil, HumanoidModel model, ResourceLocation texture, boolean innerModel, float red, float green, float blue) {
        VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)PalladiumRenderTypes.getArmorTranslucent(texture), (boolean)false, (boolean)foil);
        model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    @Inject(method={"renderModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderModel(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ArmorItem armorItem, HumanoidModel model, boolean withGlint, float red, float green, float blue, @Nullable String armorSuffix, CallbackInfo ci) {
        if (model instanceof CancelGeckoArmorBuffer) {
            model.m_7695_(poseStack, null, packedLight, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            ci.cancel();
        }
    }
}

