/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin.client;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumAttributes;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.network.SetFlyingStateMessage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public class LocalPlayerMixin {
    @Unique
    private boolean cachedMayFly = false;

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;onUpdateAbilities()V", ordinal=1, shift=At.Shift.AFTER)})
    private void onFlyChange(CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        if (player instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
            FlightHandler flight = extension.palladium$getFlightHandler();
            if (player.m_150110_().f_35935_) {
                if (flight.getFlightType().isNotNull()) {
                    new SetFlyingStateMessage(false).send();
                    flight.setFlightType(FlightHandler.FlightType.NONE);
                } else {
                    FlightHandler.FlightType flightType = FlightHandler.getAvailableFlightType((LivingEntity)player);
                    if (flightType.isNull()) {
                        return;
                    }
                    new SetFlyingStateMessage(true).send();
                    flight.setFlightType(flightType);
                }
            } else {
                new SetFlyingStateMessage(false).send();
                flight.setFlightType(FlightHandler.FlightType.NONE);
            }
            player.m_150110_().f_35935_ = false;
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void aiStepTop(CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        this.cachedMayFly = player.m_150110_().f_35936_;
        player.m_150110_().f_35936_ = player.m_150110_().f_35936_ | (player.m_21133_((Attribute)PalladiumAttributes.LEVITATION_SPEED.get()) > 0.0 || player.m_21133_((Attribute)PalladiumAttributes.FLIGHT_SPEED.get()) > 0.0);
    }

    @Inject(method={"aiStep"}, at={@At(value="RETURN")})
    private void aiStepBottom(CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        player.m_150110_().f_35936_ = this.cachedMayFly;
    }
}

