/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.client.model.animation.PalladiumAnimationRegistry;
import net.threetag.palladium.client.renderer.item.armor.ArmorRendererManager;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.entity.PlayerModelCacheExtension;
import net.threetag.palladium.mixin.client.AgeableListModelInvoker;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AnimationTimer;
import net.threetag.palladium.util.Easing;
import net.threetag.palladium.util.RenderUtil;
import net.threetag.palladium.util.context.DataContext;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerRenderer.class})
public class PlayerRendererMixin {
    private float cachedHandShrink = 0.0f;
    private BodyPart.ModifiedBodyPartResult cachedHideResult = null;

    @Inject(at={@At(value="HEAD")}, method={"renderHand"})
    public void renderHandPre(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, ModelPart rendererArm, ModelPart rendererArmwear, CallbackInfo ci) {
        PlayerRenderer playerRenderer = (PlayerRenderer)this;
        RenderUtil.REDIRECT_GET_BUFFER = true;
        PalladiumAnimationRegistry.SKIP_ANIMATIONS = true;
        PalladiumAnimationRegistry.applyFirstPersonAnimations(poseStack, player, (HumanoidModel)playerRenderer.m_7200_(), rendererArm == ((PlayerModel)playerRenderer.m_7200_()).f_102811_);
        EntityModel entityModel = playerRenderer.m_7200_();
        if (entityModel instanceof AgeableListModelInvoker) {
            AgeableListModelInvoker invoker = (AgeableListModelInvoker)entityModel;
            PalladiumAnimationRegistry.resetPoses(invoker.invokeHeadParts(), invoker.invokeBodyParts());
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V", shift=At.Shift.AFTER)}, method={"renderHand"})
    public void renderHandPreRender(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, ModelPart rendererArm, ModelPart rendererArmwear, CallbackInfo ci) {
        float scale;
        BodyPart bodyPartOverlay;
        PlayerRenderer playerRenderer = (PlayerRenderer)this;
        PalladiumAnimationRegistry.SKIP_ANIMATIONS = false;
        BodyPart.resetBodyParts((LivingEntity)player, (HumanoidModel)playerRenderer.m_7200_());
        this.cachedHideResult = BodyPart.getModifiedBodyParts((LivingEntity)player, true);
        BodyPart bodyPart = rendererArm == ((PlayerModel)playerRenderer.m_7200_()).f_102811_ ? BodyPart.RIGHT_ARM : BodyPart.LEFT_ARM;
        BodyPart bodyPart2 = bodyPartOverlay = rendererArm == ((PlayerModel)playerRenderer.m_7200_()).f_102811_ ? BodyPart.RIGHT_ARM_OVERLAY : BodyPart.LEFT_ARM_OVERLAY;
        if (this.cachedHideResult.isHiddenOrRemoved(bodyPart)) {
            rendererArm.f_104207_ = false;
        }
        if (this.cachedHideResult.isHiddenOrRemoved(bodyPartOverlay)) {
            rendererArmwear.f_104207_ = false;
        }
        if ((scale = AnimationTimer.getValue((LivingEntity)player, (Ability)Abilities.SHRINK_BODY_OVERLAY.get(), Minecraft.m_91087_().m_91296_(), Easing.INOUTSINE)) != 0.0f) {
            float f;
            this.cachedHandShrink = f = -0.11f * scale;
            Vector3f vec = new Vector3f(f, f, f);
            rendererArmwear.m_253072_(vec);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderHand"})
    public void renderHandPost(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, ModelPart rendererArm, ModelPart rendererArmwear, CallbackInfo ci) {
        PlayerRenderer playerRenderer = (PlayerRenderer)this;
        boolean rightArm = rendererArm == ((PlayerModel)playerRenderer.m_7200_()).f_102811_;
        BodyPart.resetBodyParts((LivingEntity)player, (HumanoidModel)playerRenderer.m_7200_());
        BodyPart.hideRemovedParts((HumanoidModel)playerRenderer.m_7200_(), (LivingEntity)player, this.cachedHideResult);
        this.cachedHideResult = null;
        Accessory.getPlayerData((Player)player).ifPresent(data -> data.getSlots().forEach((slot, accessories) -> {
            for (Accessory accessory : accessories) {
                HumanoidArm arm;
                HumanoidArm humanoidArm = arm = rightArm ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
                if (!accessory.isVisible((AccessorySlot)slot, player, true) || !accessory.canRenderAsArm((AccessorySlot)slot, arm, player)) continue;
                accessory.renderArm(arm, player, playerRenderer, rendererArm, rendererArmwear, (AccessorySlot)slot, poseStack, buffer, combinedLight);
            }
        }));
        ArmorRendererManager.renderFirstPerson(player, poseStack, buffer, combinedLight, rendererArm, rightArm);
        PackRenderLayerManager.forEachLayer((Entity)player, (context, layer) -> layer.renderArm((DataContext)context, rightArm ? HumanoidArm.RIGHT : HumanoidArm.LEFT, playerRenderer, poseStack, buffer, combinedLight));
        RenderUtil.REDIRECT_GET_BUFFER = false;
        if (this.cachedHandShrink != 0.0f) {
            float f = -this.cachedHandShrink;
            this.cachedHandShrink = 0.0f;
            Vector3f vec = new Vector3f(f, f, f);
            rendererArmwear.m_253072_(vec);
        }
        if (player instanceof PlayerModelCacheExtension) {
            Entity entity;
            PlayerModelCacheExtension ext = (PlayerModelCacheExtension)player;
            float partialTick = Minecraft.m_91087_().m_91296_();
            float f = Mth.m_14189_((float)partialTick, (float)player.f_20884_, (float)player.f_20883_);
            float g = Mth.m_14189_((float)partialTick, (float)player.f_20886_, (float)player.f_20885_);
            float h = g - f;
            float k = 0.0f;
            float l = 0.0f;
            if (!player.m_20159_() && player.m_6084_()) {
                k = player.f_267362_.m_267711_(partialTick);
                l = player.f_267362_.m_267590_(partialTick);
                if (player.m_6162_()) {
                    l *= 3.0f;
                }
                if (k > 1.0f) {
                    k = 1.0f;
                }
            }
            if (player.m_20159_() && (entity = player.m_20202_()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = Mth.m_14189_((float)partialTick, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
                h = g - f;
                float i = Mth.m_14177_((float)h);
                if (i < -85.0f) {
                    i = -85.0f;
                }
                if (i >= 85.0f) {
                    i = 85.0f;
                }
                f = g - i;
                if (i * i > 2500.0f) {
                    f += i * 0.2f;
                }
                h = g - f;
            }
            float j = Mth.m_14179_((float)partialTick, (float)player.f_19860_, (float)player.m_146909_());
            if (LivingEntityRenderer.m_194453_((LivingEntity)player)) {
                j *= -1.0f;
                h *= -1.0f;
            }
            ext.palladium$getCachedModel().m_6839_((LivingEntity)player, l, k, partialTick);
            ext.palladium$getCachedModel().m_6973_((LivingEntity)player, l, k, (float)player.f_19797_ + partialTick, h, j);
            if (!PalladiumAnimationRegistry.SKIP_ANIMATIONS) {
                PalladiumAnimationRegistry.applyAnimations(ext.palladium$getCachedModel(), (LivingEntity)player, l, k, (float)player.f_19797_ + partialTick, h, j);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"setModelProperties"})
    private void setModelProperties(AbstractClientPlayer clientPlayer, CallbackInfo ci) {
        PlayerRenderer renderer = (PlayerRenderer)this;
        PlayerModel playerModel = (PlayerModel)renderer.m_7200_();
        if (playerModel.f_102817_ && clientPlayer instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)clientPlayer;
            FlightHandler flightHandler = extension.palladium$getFlightHandler();
            float hover = flightHandler.getHoveringAnimation(0.0f);
            float levitation = flightHandler.getLevitationAnimation(0.0f);
            float flight = flightHandler.getFlightAnimation(0.0f);
            if (hover > 0.0f || levitation > 0.0f || flight > 0.0f) {
                playerModel.f_102817_ = false;
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getRenderOffset(Lnet/minecraft/client/player/AbstractClientPlayer;F)Lnet/minecraft/world/phys/Vec3;"}, cancellable=true)
    public void getRenderOffset(AbstractClientPlayer entity, float partialTicks, CallbackInfoReturnable<Vec3> cir) {
        if (entity instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)entity;
            FlightHandler flightHandler = extension.palladium$getFlightHandler();
            float hover = flightHandler.getHoveringAnimation(0.0f);
            float levitation = flightHandler.getLevitationAnimation(0.0f);
            float flight = flightHandler.getFlightAnimation(0.0f);
            if (hover > 0.0f || levitation > 0.0f || flight > 0.0f) {
                cir.setReturnValue((Object)Vec3.f_82478_);
            }
        }
    }
}

