/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.util.property.PalladiumProperties;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladiumcore.network.MessageC2S;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageType;

public class NotifyMovementKeyListenerMessage
extends MessageC2S {
    private final int type;
    private final boolean active;

    public NotifyMovementKeyListenerMessage(int type, boolean active) {
        this.type = type;
        this.active = active;
    }

    public NotifyMovementKeyListenerMessage(FriendlyByteBuf buf) {
        this.type = buf.readInt();
        this.active = buf.readBoolean();
    }

    public MessageType getType() {
        return PalladiumNetwork.NOTIFY_MOVEMENT_KEY_LISTENER;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.type);
        buf.writeBoolean(this.active);
    }

    public void handle(MessageContext context) {
        PalladiumProperty<Boolean> property = null;
        switch (this.type) {
            case 0: {
                property = PalladiumProperties.JUMP_KEY_DOWN;
                break;
            }
            case 1: {
                property = PalladiumProperties.LEFT_KEY_DOWN;
                break;
            }
            case 2: {
                property = PalladiumProperties.RIGHT_KEY_DOWN;
                break;
            }
            case 3: {
                property = PalladiumProperties.FORWARD_KEY_DOWN;
                break;
            }
            case 4: {
                property = PalladiumProperties.BACKWARDS_KEY_DOWN;
            }
        }
        if (property != null) {
            property.set((Entity)context.getPlayer(), this.active);
        }
    }
}

