/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.power.energybar.EnergyBar;
import net.threetag.palladium.power.energybar.EnergyBarReference;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;
import org.jetbrains.annotations.NotNull;

public class SetEnergyBarMessage
extends MessageS2C {
    private final int entityId;
    private final EnergyBarReference reference;
    private final int value;
    private final int maxValue;

    public SetEnergyBarMessage(int entityId, EnergyBarReference reference, int value, int maxValue) {
        this.entityId = entityId;
        this.reference = reference;
        this.value = value;
        this.maxValue = maxValue;
    }

    public SetEnergyBarMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.reference = EnergyBarReference.fromBuffer(buf);
        this.value = buf.readInt();
        this.maxValue = buf.readInt();
    }

    @NotNull
    public MessageType getType() {
        return PalladiumNetwork.SET_ENERGY_BAR;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        this.reference.toBuffer(buf);
        buf.writeInt(this.value);
        buf.writeInt(this.maxValue);
    }

    public void handle(MessageContext context) {
        LivingEntity living;
        EnergyBar energyBar;
        Entity entity = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_6815_(this.entityId);
        if (entity instanceof LivingEntity && (energyBar = this.reference.getEntry(living = (LivingEntity)entity)) != null) {
            energyBar.set(this.value);
            energyBar.setMax(this.maxValue);
        }
    }
}

