/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.network.SyncFlightStateMessage;
import net.threetag.palladiumcore.network.MessageC2S;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageType;

public class SetFlyingStateMessage
extends MessageC2S {
    private final boolean flying;

    public SetFlyingStateMessage(boolean flying) {
        this.flying = flying;
    }

    public SetFlyingStateMessage(FriendlyByteBuf buf) {
        this.flying = buf.readBoolean();
    }

    public MessageType getType() {
        return PalladiumNetwork.SET_FLYING_STATE;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.flying);
    }

    public void handle(MessageContext context) {
        ServerPlayer serverPlayer = context.getPlayer();
        if (serverPlayer instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)serverPlayer;
            FlightHandler flight = extension.palladium$getFlightHandler();
            if (this.flying) {
                FlightHandler.FlightType flightType = FlightHandler.getAvailableFlightType((LivingEntity)context.getPlayer());
                if (flightType.isNotNull()) {
                    flight.setFlightType(flightType);
                }
            } else {
                flight.setFlightType(FlightHandler.FlightType.NONE);
            }
            context.getPlayer().m_150110_().f_35935_ = false;
            new SyncFlightStateMessage(context.getPlayer().m_19879_(), this.flying).sendToTracking((Entity)context.getPlayer());
        }
    }
}

