/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.Collection;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessoryPlayerData;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladiumcore.network.MessageC2S;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageType;

public class ToggleAccessoryMessage
extends MessageC2S {
    public AccessorySlot slot;
    public Accessory accessory;

    public ToggleAccessoryMessage(AccessorySlot slot, Accessory accessory) {
        this.slot = slot;
        this.accessory = accessory;
    }

    public ToggleAccessoryMessage(FriendlyByteBuf buf) {
        this.slot = AccessorySlot.getSlotByName(buf.m_130281_());
        this.accessory = (Accessory)Accessory.REGISTRY.get(buf.m_130281_());
    }

    public MessageType getType() {
        return PalladiumNetwork.TOGGLE_ACCESSORY;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.slot.getName());
        buf.m_130085_(Objects.requireNonNull(Accessory.REGISTRY.getKey((Object)this.accessory)));
    }

    public void handle(MessageContext context) {
        ServerPlayer player = context.getPlayer();
        if (player != null) {
            Accessory.getPlayerData((Player)player).ifPresent(arg_0 -> this.lambda$handle$0((Player)player, arg_0));
        }
    }

    private /* synthetic */ void lambda$handle$0(Player player, AccessoryPlayerData data) {
        if (this.slot != null && this.accessory != null) {
            Collection<Accessory> accessories = data.getSlots().get(this.slot);
            if (accessories == null || !accessories.contains(this.accessory)) {
                data.enable(this.slot, this.accessory, player);
            } else {
                data.disable(this.slot, this.accessory, player);
            }
        }
    }
}

