/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.IPowerValidator;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.energybar.EnergyBar;
import net.threetag.palladium.power.energybar.EnergyBarConfiguration;

public class DefaultPowerHolder
implements IPowerHolder {
    public final LivingEntity entity;
    private final Power power;
    private final ImmutableMap<String, AbilityInstance> abilityInstances;
    private final ImmutableMap<String, EnergyBar> energyBars;
    private IPowerValidator validator;

    public DefaultPowerHolder(LivingEntity entity, Power power, IPowerValidator validator) {
        this.entity = entity;
        this.power = power;
        this.validator = validator;
        HashMap<String, AbilityInstance> abilities = new HashMap<String, AbilityInstance>();
        for (AbilityConfiguration ability : this.getPower().getAbilities()) {
            AbilityInstance entry = new AbilityInstance(ability, this);
            entry.id = ability.getId();
            abilities.put(ability.getId(), entry);
        }
        this.abilityInstances = ImmutableMap.copyOf(abilities);
        LinkedHashMap<String, EnergyBar> energyBars = new LinkedHashMap<String, EnergyBar>();
        for (EnergyBarConfiguration energyBar : this.getPower().getEnergyBars()) {
            energyBars.put(energyBar.getName(), new EnergyBar(this, energyBar));
        }
        this.energyBars = ImmutableMap.copyOf(energyBars);
    }

    @Override
    public Power getPower() {
        return this.power;
    }

    @Override
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Override
    public void fromNBT(CompoundTag tag) {
        for (Map.Entry entry : this.abilityInstances.entrySet()) {
            if (!tag.m_128441_((String)entry.getKey())) continue;
            CompoundTag abData = tag.m_128469_((String)entry.getKey());
            ((AbilityInstance)entry.getValue()).fromNBT(abData);
        }
        if (tag.m_128425_("_EnergyBars", 10)) {
            CompoundTag energies = tag.m_128469_("_EnergyBars");
            for (String key : energies.m_128431_()) {
                if (!this.energyBars.containsKey((Object)key)) continue;
                ((EnergyBar)this.energyBars.get((Object)key)).fromNBT(energies.m_128469_(key));
            }
        }
    }

    @Override
    public CompoundTag toNBT(boolean toDisk) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry entry : this.abilityInstances.entrySet()) {
            CompoundTag abData = ((AbilityInstance)entry.getValue()).toNBT(toDisk);
            tag.m_128365_((String)entry.getKey(), (Tag)abData);
        }
        CompoundTag energies = new CompoundTag();
        for (Map.Entry entry : this.energyBars.entrySet()) {
            energies.m_128365_((String)entry.getKey(), (Tag)((EnergyBar)entry.getValue()).toNBT());
        }
        tag.m_128365_("_EnergyBars", (Tag)energies);
        return tag;
    }

    public ImmutableMap<String, AbilityInstance> getAbilities() {
        return this.abilityInstances;
    }

    public ImmutableMap<String, EnergyBar> getEnergyBars() {
        return this.energyBars;
    }

    @Override
    public void tick() {
        for (AbilityInstance abilityInstance : this.abilityInstances.values()) {
            abilityInstance.tick(this.entity, this);
        }
        if (!this.getEntity().m_9236_().f_46443_) {
            for (EnergyBar energyBar : this.energyBars.values()) {
                energyBar.tick(this.entity);
            }
        }
    }

    @Override
    public void firstTick() {
        this.abilityInstances.forEach((id, entry) -> entry.getConfiguration().getAbility().firstTick(this.entity, (AbilityInstance)entry, this, entry.isEnabled()));
    }

    @Override
    public void lastTick() {
        this.abilityInstances.forEach((id, entry) -> entry.getConfiguration().getAbility().lastTick(this.entity, (AbilityInstance)entry, this, entry.isEnabled()));
    }

    @Override
    public boolean isInvalid() {
        return this.power.isInvalid() || !this.validator.stillValid(this.entity, this.power);
    }

    @Override
    public void switchValidator(IPowerValidator validator) {
        this.validator = validator;
    }
}

