/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladiumcore.registry.ReloadListenerRegistry;
import org.jetbrains.annotations.Nullable;

public class ItemPowerManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static ItemPowerManager INSTANCE;
    private final Map<String, Map<Item, List<Power>>> itemPowers = new HashMap<String, Map<Item, List<Power>>>();

    public static void init() {
        INSTANCE = new ItemPowerManager();
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (ResourceLocation)Palladium.id("item_powers"), (PreparableReloadListener)INSTANCE);
    }

    public ItemPowerManager() {
        super(GSON, "palladium/item_powers");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.itemPowers.clear();
        object.forEach((id, json) -> {
            try {
                JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)json, (String)"$");
                String slot = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"slot");
                ArrayList<Object> powers = new ArrayList<Object>();
                if (jsonObject.get("power").isJsonPrimitive()) {
                    Power power = PowerManager.getInstance(null).getPower(new ResourceLocation(jsonObject.get("power").getAsString()));
                    if (power == null) {
                        AddonPackLog.warning("Unknown power used for item '" + jsonObject.get("power").getAsString() + "'", new Object[0]);
                    } else {
                        powers.add(power);
                    }
                } else if (jsonObject.get("power").isJsonArray()) {
                    for (JsonElement jsonElement : GsonHelper.m_13933_((JsonObject)jsonObject, (String)"power")) {
                        Power power = PowerManager.getInstance(null).getPower(new ResourceLocation(jsonElement.getAsString()));
                        if (power == null) {
                            AddonPackLog.warning("Unknown power used for item '" + jsonElement.getAsString() + "'", new Object[0]);
                            continue;
                        }
                        powers.add(power);
                    }
                } else {
                    throw new JsonSyntaxException("Expected power to be string or array of strings");
                }
                List<Object> items = new ArrayList();
                if (jsonObject.get("item").isJsonPrimitive()) {
                    ResourceLocation itemId = new ResourceLocation(jsonObject.get("item").getAsString());
                    if (!BuiltInRegistries.f_257033_.m_7804_(itemId)) {
                        throw new JsonParseException("Unknown item '" + String.valueOf(itemId) + "'");
                    }
                    items = List.of((Item)BuiltInRegistries.f_257033_.m_7745_(itemId));
                } else if (jsonObject.get("item").isJsonArray()) {
                    for (JsonElement jsonElement : GsonHelper.m_13933_((JsonObject)jsonObject, (String)"item")) {
                        ResourceLocation itemId = new ResourceLocation(jsonElement.getAsString());
                        if (!BuiltInRegistries.f_257033_.m_7804_(itemId)) {
                            throw new JsonParseException("Unknown item '" + String.valueOf(itemId) + "'");
                        }
                        items.add((Item)BuiltInRegistries.f_257033_.m_7745_(itemId));
                    }
                } else {
                    throw new JsonSyntaxException("Expected item to be string or array of strings");
                }
                for (Item item : items) {
                    this.itemPowers.computeIfAbsent(slot, s -> new HashMap()).computeIfAbsent(item, item1 -> new ArrayList()).addAll(powers);
                }
            }
            catch (Exception exception) {
                AddonPackLog.error("Parsing error loading item powers {}", id, exception);
            }
        });
        AddonPackLog.info("Loaded {} item powers", this.itemPowers.size());
    }

    @Nullable
    public List<Power> getPowerForItem(String slot, Item item) {
        return this.itemPowers.containsKey(slot) ? this.itemPowers.get(slot).get(item) : null;
    }

    public static ItemPowerManager getInstance() {
        return INSTANCE;
    }
}

