/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.energybar.EnergyBarConfiguration;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.json.GsonUtil;

public class Power {
    private final ResourceLocation id;
    private final Component name;
    private final IIcon icon;
    private final List<AbilityConfiguration> abilities = new ArrayList<AbilityConfiguration>();
    private final List<EnergyBarConfiguration> energyBars = new ArrayList<EnergyBarConfiguration>();
    private final TextureReference background;
    private final TextureReference abilityBar;
    private final Color primaryColor;
    private final Color secondaryColor;
    private final boolean persistentData;
    private final boolean hidden;
    private final boolean allowBarShrinking;
    private final GuiDisplayType guiDisplayType;
    private boolean invalid = false;

    public Power(ResourceLocation id, Component name, IIcon icon, TextureReference background, TextureReference abilityBar, Color primaryColor, Color secondaryColor, boolean persistentData, boolean hidden, boolean allowBarShrinking, GuiDisplayType guiDisplayType) {
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.background = background;
        this.abilityBar = abilityBar;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.persistentData = persistentData;
        this.hidden = hidden;
        this.allowBarShrinking = allowBarShrinking;
        this.guiDisplayType = guiDisplayType;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public Power addAbility(AbilityConfiguration configuration) {
        this.abilities.add(configuration);
        return this;
    }

    public Power addEnergyBar(EnergyBarConfiguration configuration) {
        this.energyBars.add(configuration);
        return this;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Component getName() {
        return this.name;
    }

    public IIcon getIcon() {
        return this.icon;
    }

    public List<AbilityConfiguration> getAbilities() {
        return this.abilities;
    }

    public List<EnergyBarConfiguration> getEnergyBars() {
        return this.energyBars;
    }

    public TextureReference getBackground() {
        return this.background;
    }

    public TextureReference getAbilityBarTexture() {
        return this.abilityBar;
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public boolean hasPersistentData() {
        return this.persistentData;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean allowBarShrinking() {
        return this.allowBarShrinking;
    }

    public GuiDisplayType getGuiDisplayType() {
        return this.guiDisplayType;
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.m_130083_(this.name);
        buf.m_130079_(IconSerializer.serializeNBT(this.icon));
        buf.writeBoolean(this.background != null);
        if (this.background != null) {
            this.background.toBuffer(buf);
        }
        buf.writeBoolean(this.abilityBar != null);
        if (this.abilityBar != null) {
            this.abilityBar.toBuffer(buf);
        }
        buf.writeInt(this.primaryColor.getRGB());
        buf.writeInt(this.secondaryColor.getRGB());
        buf.writeBoolean(this.persistentData);
        buf.writeBoolean(this.hidden);
        buf.writeBoolean(this.allowBarShrinking);
        buf.writeInt(this.guiDisplayType.ordinal());
        buf.m_236828_(this.abilities, (buf1, configuration) -> configuration.toBuffer((FriendlyByteBuf)buf1));
        buf.m_236828_(this.energyBars, (friendlyByteBuf, energyBar) -> energyBar.toBuffer((FriendlyByteBuf)friendlyByteBuf));
    }

    public static Power fromBuffer(ResourceLocation id, FriendlyByteBuf buf) {
        Power power = new Power(id, buf.m_130238_(), IconSerializer.parseNBT(Objects.requireNonNull(buf.m_130260_())), buf.readBoolean() ? TextureReference.fromBuffer(buf) : null, buf.readBoolean() ? TextureReference.fromBuffer(buf) : null, new Color(buf.readInt()), new Color(buf.readInt()), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), GuiDisplayType.values()[buf.readInt()]);
        List configurations = buf.m_236845_(AbilityConfiguration::fromBuffer);
        for (AbilityConfiguration configuration : configurations) {
            power.addAbility(configuration);
        }
        List energyBars = buf.m_236845_(EnergyBarConfiguration::fromBuffer);
        for (EnergyBarConfiguration energyBar : energyBars) {
            power.addEnergyBar(energyBar);
        }
        return power;
    }

    public static Power fromJSON(ResourceLocation id, JsonObject json) {
        MutableComponent name = Component.Serializer.m_130691_((JsonElement)json.get("name"));
        TextureReference background = GsonUtil.getAsTextureReference(json, "background", null);
        TextureReference abilityBarTexture = GsonUtil.getAsTextureReference(json, "ability_bar_texture", null);
        GuiDisplayType displayType = GuiDisplayType.getByName(GsonHelper.m_13851_((JsonObject)json, (String)"gui_display_type", (String)"auto"));
        if (displayType == null) {
            throw new JsonParseException("Unknown gui display type '" + GsonHelper.m_13851_((JsonObject)json, (String)"gui_display_type", (String)"list") + "', must be either 'list' or 'tree'");
        }
        Power power = new Power(id, (Component)name, IconSerializer.parseJSON(json.get("icon")), background, abilityBarTexture, GsonUtil.getAsColor(json, "primary_color", new Color(210, 112, 49)), GsonUtil.getAsColor(json, "secondary_color", new Color(126, 97, 86)), GsonHelper.m_13855_((JsonObject)json, (String)"persistent_data", (boolean)false), GsonHelper.m_13855_((JsonObject)json, (String)"hidden", (boolean)false), GsonHelper.m_13855_((JsonObject)json, (String)"allow_bar_shrinking", (boolean)true), displayType);
        if (GsonHelper.m_13900_((JsonObject)json, (String)"abilities")) {
            JsonObject abilities = GsonHelper.m_13930_((JsonObject)json, (String)"abilities");
            for (String key : abilities.keySet()) {
                power.addAbility(AbilityConfiguration.fromJSON(key, GsonHelper.m_13930_((JsonObject)abilities, (String)key)));
            }
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"energy_bars")) {
            JsonObject energyBars = GsonHelper.m_13930_((JsonObject)json, (String)"energy_bars");
            for (String key : energyBars.keySet()) {
                power.addEnergyBar(EnergyBarConfiguration.fromJson(key, GsonHelper.m_13930_((JsonObject)energyBars, (String)key)));
            }
        }
        return power;
    }

    public static enum GuiDisplayType {
        AUTO("auto"),
        TREE("tree"),
        LIST("list");

        private final String name;

        private GuiDisplayType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static GuiDisplayType getByName(String name) {
            for (GuiDisplayType value : GuiDisplayType.values()) {
                if (!value.getName().equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }
    }
}

