/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.network.UpdatePowersMessage;
import net.threetag.palladium.power.DefaultPowerHolder;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.IPowerValidator;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerCollector;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.provider.PowerProvider;

public class PowerHandler
implements IPowerHandler {
    private final Map<ResourceLocation, IPowerHolder> powers = new HashMap<ResourceLocation, IPowerHolder>();
    private final LivingEntity entity;
    private CompoundTag powerData = new CompoundTag();

    public PowerHandler(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public Map<ResourceLocation, IPowerHolder> getPowerHolders() {
        return ImmutableMap.copyOf(this.powers);
    }

    @Override
    public void tick() {
        if (!this.entity.m_9236_().f_46443_) {
            ArrayList<IPowerHolder> toRemove = new ArrayList<IPowerHolder>();
            PowerCollector collector = new PowerCollector(this.entity, this, toRemove);
            for (IPowerHolder iPowerHolder : this.powers.values()) {
                if (!iPowerHolder.isInvalid()) continue;
                toRemove.add(iPowerHolder);
            }
            for (PowerProvider powerProvider : PowerProvider.REGISTRY.getValues()) {
                powerProvider.providePowers(this.entity, this, collector);
            }
            for (IPowerHolder iPowerHolder : toRemove) {
                this.removePowerHolder(iPowerHolder.getPower());
            }
            for (DefaultPowerHolder defaultPowerHolder : collector.getAdded()) {
                this.setPowerHolder(defaultPowerHolder.getPower(), defaultPowerHolder);
            }
            if (!toRemove.isEmpty() || !collector.getAdded().isEmpty()) {
                UpdatePowersMessage msg = new UpdatePowersMessage(this.entity, toRemove.stream().map(p -> p.getPower().getId()).toList(), collector.getAdded().stream().map(p -> p.getPower().getId()).toList());
                LivingEntity livingEntity = this.entity;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    msg.sendToTrackingAndSelf(serverPlayer);
                } else {
                    msg.sendToTracking((Entity)this.entity);
                }
            }
        }
        for (IPowerHolder holder : this.powers.values()) {
            holder.tick();
        }
    }

    public void setPowerHolder(Power power, IPowerHolder holder) {
        if (this.hasPower(power)) {
            this.powers.put(power.getId(), holder);
        } else {
            this.removePowerHolder(power);
            this.powers.put(power.getId(), holder);
            holder.fromNBT(this.powerData.m_128469_(power.getId().toString()));
            holder.firstTick();
        }
    }

    public void removePowerHolder(Power power) {
        this.removePowerHolder(power.getId());
    }

    public void removePowerHolder(ResourceLocation powerId) {
        if (this.powers.containsKey(powerId)) {
            IPowerHolder holder = this.powers.get(powerId);
            boolean isStillValid = !holder.getPower().isInvalid();
            boolean hasPersistentData = holder.getPower().hasPersistentData();
            holder.lastTick();
            if (hasPersistentData) {
                this.savePowerNbt(holder);
            }
            this.powers.remove(powerId);
            if (isStillValid && !hasPersistentData) {
                this.powerData.m_128473_(powerId.toString());
            }
        }
    }

    @Override
    public IPowerHolder getPowerHolder(Power power) {
        return this.powers.get(power.getId());
    }

    @Override
    public boolean hasPower(Power power) {
        return this.powers.containsKey(power.getId());
    }

    @Override
    public void removeAndAddPowers(List<Power> toRemove, List<Power> toAdd) {
        if (this.entity.m_9236_().f_46443_) {
            for (Power power : toRemove) {
                this.removePowerHolder(power);
            }
            for (Power power : toAdd) {
                this.setPowerHolder(power, new DefaultPowerHolder(this.entity, power, IPowerValidator.ALWAYS_ACTIVE));
            }
        }
    }

    @Override
    public void fromNBT(CompoundTag nbt) {
        this.powerData = nbt;
    }

    @Override
    public CompoundTag toNBT() {
        for (IPowerHolder holder : this.powers.values()) {
            this.savePowerNbt(holder);
        }
        this.cleanPowerData();
        return this.powerData;
    }

    public void savePowerNbt(IPowerHolder holder) {
        this.powerData.m_128365_(holder.getPower().getId().toString(), (Tag)holder.toNBT(true));
    }

    public void cleanPowerData() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : this.powerData.m_128431_()) {
            if (PowerManager.getInstance(this.entity.m_9236_()).getPower(new ResourceLocation(key)) != null) continue;
            toRemove.add(key);
        }
        for (String key : toRemove) {
            this.powerData.m_128473_(key);
        }
    }
}

