/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.condition.ChatMessageCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.entity.PalladiumLivingEntityExtension;
import net.threetag.palladium.network.SyncPowersMessage;
import net.threetag.palladium.power.ClientPowerManager;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladiumcore.event.ChatEvents;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.LivingEntityEvents;
import net.threetag.palladiumcore.registry.ReloadListenerRegistry;
import net.threetag.palladiumcore.util.DataSyncUtil;
import org.jetbrains.annotations.Nullable;

public class PowerManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static PowerManager INSTANCE;
    public Map<ResourceLocation, Power> byName = ImmutableMap.of();
    public static final List<String> CHECK_FOR_CHAT_MESSAGES;

    public static void init() {
        INSTANCE = new PowerManager();
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (ResourceLocation)Palladium.id("powers"), (PreparableReloadListener)INSTANCE);
        LivingEntityEvents.TICK.register(entity -> PowerManager.getPowerHandler(entity).ifPresent(IPowerHandler::tick));
        DataSyncUtil.registerDataSync(consumer -> consumer.accept(new SyncPowersMessage(PowerManager.getInstance((boolean)true).byName)));
        ChatEvents.SERVER_SUBMITTED.register((player, rawMessage, message) -> {
            if (CHECK_FOR_CHAT_MESSAGES.contains(rawMessage.trim().toLowerCase(Locale.ROOT))) {
                for (AbilityInstance instance : AbilityUtil.getInstances((LivingEntity)player)) {
                    ChatMessageCondition chat;
                    for (Condition condition : instance.getConfiguration().getUnlockingConditions()) {
                        if (!(condition instanceof ChatMessageCondition)) continue;
                        chat = (ChatMessageCondition)condition;
                        if (!chat.chatMessage.trim().equalsIgnoreCase(rawMessage.trim())) continue;
                        chat.onChat((LivingEntity)player, instance);
                    }
                    for (Condition condition : instance.getConfiguration().getEnablingConditions()) {
                        if (!(condition instanceof ChatMessageCondition)) continue;
                        chat = (ChatMessageCondition)condition;
                        if (!chat.chatMessage.trim().equalsIgnoreCase(rawMessage.trim())) continue;
                        chat.onChat((LivingEntity)player, instance);
                    }
                }
            }
            return EventResult.pass();
        });
    }

    public PowerManager() {
        super(GSON, "palladium/powers");
    }

    public static PowerManager getInstance(boolean server) {
        return !server ? ClientPowerManager.INSTANCE : INSTANCE;
    }

    public static PowerManager getInstance(@Nullable Level level) {
        return level != null && level.f_46443_ ? ClientPowerManager.INSTANCE : INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        CHECK_FOR_CHAT_MESSAGES.clear();
        object.forEach((id, json) -> {
            try {
                builder.put(id, (Object)Power.fromJSON(id, json.getAsJsonObject()));
            }
            catch (Exception e) {
                AddonPackLog.error("Parsing error loading power {}", id, e);
            }
        });
        this.byName.values().forEach(Power::invalidate);
        this.byName = builder.build();
        AddonPackLog.info("Loaded {} powers", this.byName.size());
    }

    public Power getPower(ResourceLocation id) {
        return this.byName.get(id);
    }

    public Set<ResourceLocation> getIds() {
        return this.byName.keySet();
    }

    public Collection<Power> getPowers() {
        return this.byName.values();
    }

    public static Optional<PowerHandler> getPowerHandler(LivingEntity entity) {
        if (entity instanceof PalladiumLivingEntityExtension) {
            PalladiumLivingEntityExtension ext = (PalladiumLivingEntityExtension)entity;
            return Optional.of(ext.palladium$getPowerHandler());
        }
        return Optional.empty();
    }

    static {
        CHECK_FOR_CHAT_MESSAGES = new ArrayList<String>();
    }
}

