/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.condition.AbilityWheelCondition;
import net.threetag.palladium.condition.BuyableCondition;
import net.threetag.palladium.condition.ChatMessageCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.CooldownType;
import net.threetag.palladium.condition.KeyCondition;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.energybar.EnergyBarUsage;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import org.jetbrains.annotations.Nullable;

public class AbilityConfiguration {
    private final String id;
    private final Ability ability;
    private final PropertyManager propertyManager;
    private final List<Condition> unlockingConditions = new ArrayList<Condition>();
    private final List<Condition> enablingConditions = new ArrayList<Condition>();
    private boolean buyable = false;
    private CooldownType cooldownType = CooldownType.STATIC;
    private boolean needsKey = false;
    private boolean needsEmptyHand = false;
    private boolean allowScrollWhenCrouching = true;
    private KeyType keyType = KeyType.KEY_BIND;
    private KeyPressType keyPressType = KeyPressType.ACTION;
    public List<String> dependencies = new ArrayList<String>();
    private final List<EnergyBarUsage> energyBarUsages = new ArrayList<EnergyBarUsage>();

    public AbilityConfiguration(String id, Ability ability) {
        this.id = id;
        this.ability = ability;
        this.propertyManager = ability.propertyManager.copy();
    }

    public String getId() {
        return this.id;
    }

    public Ability getAbility() {
        return this.ability;
    }

    public Component getDisplayName() {
        Component title = this.propertyManager.get(Ability.TITLE);
        ResourceLocation id = Ability.REGISTRY.getKey((Object)this.getAbility());
        return title != null ? title : Component.m_237115_((String)("ability." + Objects.requireNonNull(id).m_135827_() + "." + id.m_135815_()));
    }

    public List<EnergyBarUsage> getEnergyBarUsages() {
        return this.energyBarUsages;
    }

    public <T> AbilityConfiguration set(PalladiumProperty<T> data, T value) {
        this.propertyManager.set(data, value);
        return this;
    }

    public <T> T get(PalladiumProperty<T> property) {
        return this.propertyManager.get(property);
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public List<Condition> getUnlockingConditions() {
        return this.unlockingConditions;
    }

    public List<Condition> getEnablingConditions() {
        return this.enablingConditions;
    }

    public CooldownType getCooldownType() {
        return this.cooldownType;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public boolean needsKey() {
        return this.needsKey;
    }

    public boolean needsEmptyHand() {
        return this.needsEmptyHand;
    }

    public boolean allowScrollWhenCrouching() {
        return this.allowScrollWhenCrouching;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public KeyPressType getKeyPressType() {
        return this.keyPressType;
    }

    public boolean isBuyable() {
        return this.buyable;
    }

    @Nullable
    public BuyableCondition findBuyCondition() {
        for (Condition condition : this.getUnlockingConditions()) {
            if (!(condition instanceof BuyableCondition)) continue;
            BuyableCondition buyableCondition = (BuyableCondition)condition;
            return buyableCondition;
        }
        return null;
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.m_130070_(this.id);
        buf.m_130085_(Objects.requireNonNull(Ability.REGISTRY.getKey((Object)this.ability)));
        this.propertyManager.toBuffer(buf);
        buf.writeBoolean(this.needsKey);
        buf.writeBoolean(this.needsEmptyHand);
        buf.writeBoolean(this.allowScrollWhenCrouching);
        buf.writeBoolean(this.buyable);
        buf.writeInt(this.keyType.ordinal());
        buf.writeInt(this.keyPressType.ordinal());
        buf.writeInt(this.cooldownType.ordinal());
        buf.writeInt(this.dependencies.size());
        for (String s : this.dependencies) {
            buf.m_130070_(s);
        }
    }

    public static AbilityConfiguration fromBuffer(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        Ability ability = (Ability)Ability.REGISTRY.get(buf.m_130281_());
        AbilityConfiguration configuration = new AbilityConfiguration(id, Objects.requireNonNull(ability));
        configuration.propertyManager.fromBuffer(buf);
        configuration.needsKey = buf.readBoolean();
        configuration.needsEmptyHand = buf.readBoolean();
        configuration.allowScrollWhenCrouching = buf.readBoolean();
        configuration.buyable = buf.readBoolean();
        configuration.keyType = KeyType.values()[buf.readInt()];
        configuration.keyPressType = KeyPressType.values()[buf.readInt()];
        configuration.cooldownType = CooldownType.values()[buf.readInt()];
        int keys = buf.readInt();
        for (int i = 0; i < keys; ++i) {
            configuration.dependencies.add(buf.m_130277_());
        }
        return configuration;
    }

    public static AbilityConfiguration fromJSON(String id, JsonObject json) {
        Ability ability;
        ResourceLocation abilityId = GsonUtil.getAsResourceLocation(json, "type");
        if (abilityId.equals((Object)Palladium.id("interpolated_integer"))) {
            abilityId = Abilities.ANIMATION_TIMER.getId();
            AddonPackLog.warning("'interpolated_integer' ability found in power, please use 'animation_timer' instead!", new Object[0]);
        }
        if (abilityId.equals((Object)Palladium.id("hide_body_parts"))) {
            abilityId = Abilities.REMOVE_BODY_PART.getId();
            AddonPackLog.warning("'hide_body_parts' ability found in power, please use 'remove_body_part' instead!", new Object[0]);
        }
        if ((ability = (Ability)Ability.REGISTRY.get(abilityId)) == null) {
            if (GsonHelper.m_13900_((JsonObject)json, (String)"ability")) {
                ability = (Ability)Ability.REGISTRY.get(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"ability")));
                AddonPackLog.warning("Usage of 'ability' in ability declarations is deprecated!", new Object[0]);
                if (ability == null) {
                    throw new JsonParseException("Ability '" + GsonHelper.m_13906_((JsonObject)json, (String)"ability") + "' does not exist!");
                }
            } else {
                throw new JsonParseException("Ability '" + GsonHelper.m_13906_((JsonObject)json, (String)"type") + "' does not exist!");
            }
        }
        AbilityConfiguration configuration = new AbilityConfiguration(id, ability);
        configuration.propertyManager.fromJSON(json);
        if (GsonHelper.m_13900_((JsonObject)json, (String)"energy_bar_usage")) {
            GsonUtil.fromListOrPrimitive(json.get("energy_bar_usage"), jsonElement -> configuration.energyBarUsages.add(EnergyBarUsage.fromJson(GsonHelper.m_13918_((JsonElement)jsonElement, (String)"energy_bar_usage"))));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"conditions")) {
            List<Condition> condList;
            JsonElement condJson;
            JsonObject conditions = GsonHelper.m_13930_((JsonObject)json, (String)"conditions");
            boolean withKeyOrChat = false;
            boolean withKey = false;
            CooldownType cooldownType = null;
            if (GsonHelper.m_13900_((JsonObject)conditions, (String)"unlocking")) {
                condJson = conditions.get("unlocking");
                condList = ConditionSerializer.listFromJSON(condJson, ConditionEnvironment.DATA);
                for (Condition condition : condList) {
                    if (condition instanceof BuyableCondition) {
                        BuyableCondition buyableCondition = (BuyableCondition)condition;
                        if (configuration.buyable) {
                            throw new JsonParseException("Can't have more than one buyable unlock condition!");
                        }
                        configuration.buyable = true;
                    }
                    if (condition.needsKey() || condition instanceof ChatMessageCondition || condition instanceof AbilityWheelCondition) {
                        throw new JsonParseException("Can't have key binding, chat message or ability wheel conditions for unlocking!");
                    }
                    if (condition.handlesCooldown()) {
                        if (cooldownType != null) {
                            throw new JsonParseException("Can't have two abilities handling the cooldown!");
                        }
                        cooldownType = condition.getCooldownType();
                    }
                    configuration.getUnlockingConditions().add(condition);
                    configuration.dependencies.addAll(condition.getDependentAbilities());
                }
            }
            if (GsonHelper.m_13900_((JsonObject)conditions, (String)"enabling")) {
                condJson = conditions.get("enabling");
                condList = ConditionSerializer.listFromJSON(condJson, ConditionEnvironment.DATA);
                for (Condition condition : condList) {
                    if (condition instanceof BuyableCondition) {
                        throw new JsonParseException("Can't have a buyable unlock condition for enabling!");
                    }
                    if (condition.needsKey() || condition instanceof ChatMessageCondition || condition instanceof AbilityWheelCondition) {
                        if (withKeyOrChat) {
                            throw new JsonParseException("Can't have two key binding, chat message or ability wheel conditions on one ability!");
                        }
                        withKeyOrChat = true;
                        if (condition.needsKey()) {
                            withKey = true;
                            configuration.keyType = condition.getKeyType();
                            configuration.keyPressType = condition.getKeyPressType();
                            if (condition instanceof KeyCondition) {
                                KeyCondition key = (KeyCondition)condition;
                                configuration.needsEmptyHand = key.needsEmptyHand();
                                configuration.allowScrollWhenCrouching = key.allowScrollingWhenCrouching();
                            }
                        }
                    }
                    if (condition.handlesCooldown()) {
                        if (cooldownType != null) {
                            throw new JsonParseException("Can't have two abilities handling the cooldown!");
                        }
                        cooldownType = condition.getCooldownType();
                    }
                    configuration.getEnablingConditions().add(condition);
                    configuration.dependencies.addAll(condition.getDependentAbilities());
                }
            }
            if (withKey) {
                configuration.needsKey = true;
            }
            configuration.cooldownType = cooldownType == null ? CooldownType.STATIC : cooldownType;
        }
        ability.postParsing(configuration);
        return configuration;
    }

    public static enum KeyType {
        KEY_BIND,
        LEFT_CLICK,
        RIGHT_CLICK,
        SPACE_BAR,
        SCROLL_UP,
        SCROLL_DOWN,
        SCROLL_EITHER;

    }

    public static enum KeyPressType {
        ACTION,
        ACTIVATION,
        TOGGLE,
        HOLD;

    }

    public static class UnlockData {
        public final IIcon icon;
        public final int amount;
        public final Component description;

        public UnlockData(IIcon icon, int amount, Component description) {
            this.icon = icon;
            this.amount = amount;
            this.description = description;
        }

        public UnlockData(FriendlyByteBuf buf) {
            this.icon = IconSerializer.parseNBT(Objects.requireNonNull(buf.m_130261_()));
            this.amount = buf.readInt();
            this.description = buf.m_130238_();
        }

        public void toBuffer(FriendlyByteBuf buf) {
            buf.m_130079_(IconSerializer.serializeNBT(this.icon));
            buf.writeInt(this.amount);
            buf.m_130083_(this.description);
        }
    }
}

