/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.threetag.palladium.entity.PalladiumAttributes;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.DamageImmunityAbility;
import net.threetag.palladium.power.ability.FireAspectAbility;
import net.threetag.palladium.power.ability.NameChangeAbility;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.LivingEntityEvents;
import net.threetag.palladiumcore.event.PlayerEvents;
import net.threetag.palladiumcore.util.PlayerUtil;

public class AbilityEventHandler
implements LivingEntityEvents.Hurt,
LivingEntityEvents.Attack,
PlayerEvents.NameFormat,
PlayerEvents.ChangedDimension {
    public static void init() {
        AbilityEventHandler handler = new AbilityEventHandler();
        LivingEntityEvents.ATTACK.register((Object)handler);
        LivingEntityEvents.HURT.register((Object)handler);
        PlayerEvents.NAME_FORMAT.register((Object)handler);
        PlayerEvents.CHANGED_DIMENSION.register((Object)handler);
    }

    public EventResult livingEntityHurt(LivingEntity entity, DamageSource damageSource, AtomicReference<Float> amount) {
        if (damageSource.m_276093_(DamageTypes.f_268612_) && AbilityUtil.isTypeEnabled(entity, (Ability)Abilities.INTANGIBILITY.get())) {
            return EventResult.cancel();
        }
        for (AbilityInstance entry : AbilityUtil.getEnabledInstances(entity, (Ability)Abilities.DAMAGE_IMMUNITY.get())) {
            if (!DamageImmunityAbility.isImmuneAgainst(entry, damageSource)) continue;
            return EventResult.cancel();
        }
        if (damageSource.m_276093_(DamageTypes.f_268671_) && entity.m_21204_().m_22171_((Attribute)PalladiumAttributes.FALL_RESISTANCE.get())) {
            double resistance = entity.m_21133_((Attribute)PalladiumAttributes.FALL_RESISTANCE.get());
            if (resistance == 100.0) {
                return EventResult.cancel();
            }
            amount.set(Float.valueOf((float)((double)amount.get().floatValue() * (1.0 / resistance))));
        }
        return EventResult.pass();
    }

    public EventResult livingEntityAttack(LivingEntity entity, DamageSource damageSource, float amount) {
        LivingEntity sourceEntity;
        Entity entity2 = damageSource.m_7639_();
        if (entity2 instanceof LivingEntity && AbilityUtil.isTypeEnabled(sourceEntity = (LivingEntity)entity2, (Ability)Abilities.FIRE_ASPECT.get())) {
            boolean hasAddedExistingFire = false;
            int fireSeconds = 0;
            for (AbilityInstance entry : AbilityUtil.getEnabledInstances(sourceEntity, (Ability)Abilities.FIRE_ASPECT.get())) {
                int time = Math.max(entry.getProperty(FireAspectAbility.TIME), 0);
                if (!hasAddedExistingFire && entry.getProperty(FireAspectAbility.SHOULD_STACK_TIME).booleanValue()) {
                    fireSeconds = Math.min(fireSeconds + entity.m_20094_() / 20, entry.getProperty(FireAspectAbility.MAX_TIME));
                    hasAddedExistingFire = true;
                }
                fireSeconds += time;
            }
            entity.m_20254_(fireSeconds);
        }
        return this.livingEntityHurt(entity, damageSource, new AtomicReference<Float>(Float.valueOf(amount)));
    }

    public void playerNameFormat(Player player, Component username, AtomicReference<Component> displayName) {
        AbilityUtil.getEnabledInstances((LivingEntity)player, (Ability)Abilities.NAME_CHANGE.get()).stream().filter(ab -> ab.getProperty(NameChangeAbility.NAME_CACHED) != null).findFirst().ifPresent(ability -> displayName.set(ability.getProperty(NameChangeAbility.NAME_CACHED)));
    }

    public void playerChangedDimension(Player player, ResourceKey<Level> destination) {
        PlayerUtil.refreshDisplayName((Player)player);
    }
}

