/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.ability.AbilityInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbilityReference {
    @Nullable
    private final ResourceLocation powerId;
    @NotNull
    private final String abilityId;

    public AbilityReference(@Nullable ResourceLocation powerId, @NotNull String abilityId) {
        this.powerId = powerId;
        this.abilityId = abilityId;
    }

    public static AbilityReference fromString(String parse) {
        String[] s = parse.split("#", 2);
        if (s.length == 1) {
            return new AbilityReference(null, s[0]);
        }
        return new AbilityReference(new ResourceLocation(s[0]), s[1]);
    }

    @Nullable
    public ResourceLocation getPowerId() {
        return this.powerId;
    }

    @NotNull
    public String getAbilityId() {
        return this.abilityId;
    }

    @Nullable
    public AbilityInstance getEntry(LivingEntity entity) {
        return this.getEntry(entity, null);
    }

    @Nullable
    public AbilityInstance getEntry(LivingEntity entity, @Nullable IPowerHolder powerHolder) {
        if (this.powerId != null) {
            IPowerHandler handler = PowerManager.getPowerHandler(entity).orElse(null);
            Power power = PowerManager.getInstance(entity.m_9236_()).getPower(this.powerId);
            powerHolder = power != null && handler != null ? handler.getPowerHolder(power) : null;
        }
        if (powerHolder != null) {
            return powerHolder.getAbilities().get(this.abilityId);
        }
        return null;
    }

    public Optional<AbilityInstance> optional(LivingEntity entity, @Nullable IPowerHolder powerHolder) {
        return Optional.ofNullable(this.getEntry(entity, powerHolder));
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.m_236821_((Object)this.powerId, (buf1, resourceLocation) -> buf.m_130085_(resourceLocation));
        buf.m_130070_(this.abilityId);
    }

    public static AbilityReference fromBuffer(FriendlyByteBuf buf) {
        return new AbilityReference((ResourceLocation)buf.m_236868_(FriendlyByteBuf::m_130281_), buf.m_130277_());
    }

    public String toString() {
        if (this.powerId == null) {
            return this.abilityId;
        }
        return String.valueOf(this.powerId) + "#" + this.abilityId;
    }

    public int hashCode() {
        return Objects.hash(this.powerId, this.abilityId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbilityReference)) {
            return false;
        }
        AbilityReference that = (AbilityReference)o;
        return Objects.equals(this.powerId, that.powerId) && Objects.equals(this.abilityId, that.abilityId);
    }
}

