/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Collections;
import java.util.Objects;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.CommandFunctionProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.SyncType;

public class CommandAbility
extends Ability
implements CommandSource {
    public static final PalladiumProperty<CommandFunctionProperty.CommandFunctionParsing> FIRST_TICK_COMMANDS = new CommandFunctionProperty("first_tick_commands").sync(SyncType.NONE).disablePersistence().configurable("Sets the commands which get executed when gaining/activating the ability");
    public static final PalladiumProperty<CommandFunctionProperty.CommandFunctionParsing> LAST_TICK_COMMANDS = new CommandFunctionProperty("last_tick_commands").sync(SyncType.NONE).disablePersistence().configurable("Sets the commands which get executed when losing/deactivating the ability");
    public static final PalladiumProperty<CommandFunctionProperty.CommandFunctionParsing> COMMANDS = new CommandFunctionProperty("commands").sync(SyncType.NONE).disablePersistence().configurable("Sets the commands which get executed when using the ability");

    public CommandAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Blocks.f_50272_));
        this.withProperty(FIRST_TICK_COMMANDS, new CommandFunctionProperty.CommandFunctionParsing(Collections.emptyList()));
        this.withProperty(LAST_TICK_COMMANDS, new CommandFunctionProperty.CommandFunctionParsing(Collections.emptyList()));
        this.withProperty(COMMANDS, new CommandFunctionProperty.CommandFunctionParsing("say Hello World"));
    }

    @Override
    public void firstTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        Level level;
        if (enabled && entity.m_9236_().m_7654_() != null && entry.getProperty(FIRST_TICK_COMMANDS) != null && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CommandSourceStack source = this.createCommandSourceStack(entity, serverLevel);
            CommandFunction function = entry.getProperty(FIRST_TICK_COMMANDS).getCommandFunction(entity.m_9236_().m_7654_());
            if (function != null) {
                Objects.requireNonNull(entity.m_9236_().m_7654_()).m_129890_().m_136112_(function, source.m_81324_().m_81358_(2));
            }
        }
    }

    @Override
    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        Level level;
        if (enabled && entity.m_9236_().m_7654_() != null && entry.getProperty(COMMANDS) != null && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CommandSourceStack source = this.createCommandSourceStack(entity, serverLevel);
            CommandFunction function = entry.getProperty(COMMANDS).getCommandFunction(entity.m_9236_().m_7654_());
            if (function != null) {
                Objects.requireNonNull(entity.m_9236_().m_7654_()).m_129890_().m_136112_(function, source.m_81324_().m_81358_(2));
            }
        }
    }

    @Override
    public void lastTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        Level level;
        if (enabled && entity.m_9236_().m_7654_() != null && entry.getProperty(LAST_TICK_COMMANDS) != null && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CommandSourceStack source = this.createCommandSourceStack(entity, serverLevel);
            CommandFunction function = entry.getProperty(LAST_TICK_COMMANDS).getCommandFunction(entity.m_9236_().m_7654_());
            if (function != null) {
                Objects.requireNonNull(entity.m_9236_().m_7654_()).m_129890_().m_136112_(function, source.m_81324_().m_81358_(2));
            }
        }
    }

    public CommandSourceStack createCommandSourceStack(LivingEntity entity, ServerLevel serverLevel) {
        return new CommandSourceStack((CommandSource)this, entity.m_20182_(), entity.m_20155_(), serverLevel, 2, entity.m_7755_().getString(), entity.m_5446_(), entity.m_9236_().m_7654_(), (Entity)entity).m_81324_();
    }

    public void m_213846_(Component component) {
    }

    public boolean m_6999_() {
        return false;
    }

    public boolean m_7028_() {
        return false;
    }

    public boolean m_6102_() {
        return false;
    }

    @Override
    public String getDocumentationDescription() {
        return "Executes commands.";
    }
}

