/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.property.FluidTagProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class FluidWalkingAbility
extends Ability {
    public static final PalladiumProperty<TagKey<Fluid>> FLUID_TAG = new FluidTagProperty("fluid_tag").configurable("Determines the tag for the fluid(s) you can walk on. You need tags because of each fluid there are 2 fluids actually: A still and a flowing one. Minecraft's two fluid tags are: minecraft:water & minecraft:lava");

    public FluidWalkingAbility() {
        this.withProperty(FLUID_TAG, FluidTags.f_13132_);
    }

    @Override
    public String getDocumentationDescription() {
        return "Let's you define a fluid you can walk on.";
    }

    public static boolean canWalkOn(LivingEntity entity, FluidState fluid) {
        if (fluid.m_205070_(FluidTags.f_13131_) && AbilityUtil.isTypeEnabled(entity, (Ability)Abilities.WATER_WALK.get())) {
            return true;
        }
        return AbilityUtil.getEnabledEntries(entity, (Ability)Abilities.FLUID_WALKING.get()).stream().anyMatch(e -> fluid.m_205070_(e.getProperty(FLUID_TAG)));
    }
}

