/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.SyncType;
import net.threetag.palladium.util.property.TextureAlignmentProperty;
import net.threetag.palladium.util.property.TextureReferenceProperty;
import net.threetag.palladium.util.property.Vec3Property;
import net.threetag.palladiumcore.registry.client.OverlayRegistry;

public class GuiOverlayAbility
extends Ability {
    public static final PalladiumProperty<TextureReference> TEXTURE = new TextureReferenceProperty("texture").sync(SyncType.SELF).configurable("Texture path for the gui overlay");
    public static final PalladiumProperty<Integer> TEXTURE_WIDTH = new IntegerProperty("texture_width").sync(SyncType.SELF).configurable("Width of the texture file");
    public static final PalladiumProperty<Integer> TEXTURE_HEIGHT = new IntegerProperty("texture_height").sync(SyncType.SELF).configurable("Width of the texture file");
    public static final PalladiumProperty<Vec3> TRANSLATE = new Vec3Property("translate").sync(SyncType.SELF).configurable("Translation of the rendered object");
    public static final PalladiumProperty<Vec3> ROTATE = new Vec3Property("rotate").sync(SyncType.SELF).configurable("Rotation of the rendered object");
    public static final PalladiumProperty<Vec3> SCALE = new Vec3Property("scale").sync(SyncType.SELF).configurable("Scale of the rendered object");
    public static final PalladiumProperty<TextureAlignmentProperty.TextureAlignment> ALIGNMENT = new TextureAlignmentProperty("alignment").sync(SyncType.SELF).configurable("Determines how the image is aligned on the screen");

    public GuiOverlayAbility() {
        this.withProperty(TEXTURE, TextureReference.normal(new ResourceLocation("textures/gui/presets/isles.png")));
        this.withProperty(TEXTURE_WIDTH, 256);
        this.withProperty(TEXTURE_HEIGHT, 256);
        this.withProperty(TRANSLATE, Vec3.f_82478_);
        this.withProperty(ROTATE, Vec3.f_82478_);
        this.withProperty(SCALE, new Vec3(1.0, 1.0, 1.0));
        this.withProperty(ALIGNMENT, TextureAlignmentProperty.TextureAlignment.STRETCH);
    }

    @Override
    public boolean isEffect() {
        return true;
    }

    @Override
    public String getDocumentationDescription() {
        return "Displays a gui overlay on the screen.";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Renderer
    implements OverlayRegistry.IngameOverlay {
        public void render(Minecraft minecraft, Gui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
            List<AbilityInstance> entries = AbilityUtil.getEnabledEntries((LivingEntity)minecraft.f_91074_, (Ability)Abilities.GUI_OVERLAY.get()).stream().sorted((a1, a2) -> (int)(a1.getProperty(GuiOverlayAbility.TRANSLATE).f_82481_ - a2.getProperty(GuiOverlayAbility.TRANSLATE).f_82481_)).toList();
            for (AbilityInstance entry : entries) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ResourceLocation texture = entry.getProperty(TEXTURE).getTexture(DataContext.forAbility((LivingEntity)minecraft.f_91074_, entry));
                Integer textureWidth = entry.getProperty(TEXTURE_WIDTH);
                Integer textureHeight = entry.getProperty(TEXTURE_HEIGHT);
                TextureAlignmentProperty.TextureAlignment alignment = entry.getProperty(ALIGNMENT);
                Vec3 translate = entry.getProperty(TRANSLATE);
                Vec3 rotate = entry.getProperty(ROTATE);
                Vec3 scale = entry.getProperty(SCALE);
                guiGraphics.m_280168_().m_85836_();
                if (alignment.isStretched()) {
                    scale = scale.m_82542_((double)((float)width / (float)textureWidth.intValue()), (double)((float)height / (float)textureHeight.intValue()), 1.0);
                }
                guiGraphics.m_280168_().m_85837_(translate.f_82479_ + (double)textureWidth.intValue() * scale.f_82479_ / 2.0, translate.f_82480_ + (double)textureWidth.intValue() * scale.f_82480_ / 2.0, translate.f_82481_);
                if (!alignment.isStretched()) {
                    int horizontal = alignment.getHorizontal();
                    int vertical = alignment.getVertical();
                    if (horizontal > 0) {
                        guiGraphics.m_280168_().m_252880_(horizontal == 1 ? (float)(width - textureWidth) / 2.0f : (float)(width - textureWidth), 0.0f, 0.0f);
                    }
                    if (vertical > 0) {
                        guiGraphics.m_280168_().m_252880_(0.0f, vertical == 1 ? (float)(height - textureHeight) / 2.0f : (float)(height - textureHeight), 0.0f);
                    }
                }
                if (rotate.f_82479_ != 0.0) {
                    guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)rotate.f_82479_));
                }
                if (rotate.f_82480_ != 0.0) {
                    guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_((float)rotate.f_82480_));
                }
                if (rotate.f_82481_ != 0.0) {
                    guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)rotate.f_82481_));
                }
                this.renderImage(guiGraphics, texture, scale, textureWidth, textureHeight);
                guiGraphics.m_280168_().m_85849_();
            }
        }

        private void renderImage(GuiGraphics guiGraphics, ResourceLocation texture, Vec3 scale, int textureWidth, int textureHeight) {
            guiGraphics.m_280168_().m_85841_((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
            guiGraphics.m_280398_(texture, -textureWidth / 2, -textureHeight / 2, 0, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
        }
    }
}

