/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class HealingAbility
extends Ability {
    public static final PalladiumProperty<Integer> FREQUENCY = new IntegerProperty("frequency").configurable("Sets the frequency of healing (in ticks)");
    public static final PalladiumProperty<Float> AMOUNT = new FloatProperty("amount").configurable("Sets the amount of hearts for each healing");

    public HealingAbility() {
        this.withProperty(FREQUENCY, 20);
        this.withProperty(AMOUNT, Float.valueOf(3.0f));
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42410_));
    }

    @Override
    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        int frequency;
        if (enabled && !entity.m_9236_().f_46443_ && (frequency = entry.getProperty(FREQUENCY).intValue()) != 0 && entity.f_19797_ % frequency == 0) {
            entity.m_5634_(entry.getProperty(AMOUNT).floatValue());
        }
    }

    @Override
    public String getDocumentationDescription() {
        return "Heals the entity.";
    }
}

