/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.particleemitter.ParticleEmitterConfiguration;
import net.threetag.palladium.client.particleemitter.ParticleEmitterManager;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ParticleTypeProperty;
import net.threetag.palladium.util.property.ResourceLocationListProperty;
import net.threetag.palladium.util.property.StringProperty;

public class ParticleAbility
extends Ability {
    public static final PalladiumProperty<List<ResourceLocation>> PARTICLE_EMITTER = new ResourceLocationListProperty("emitter").configurable("Configuration for where the particle spawns at. Check wiki for information.");
    public static final PalladiumProperty<ParticleType<?>> PARTICLE = new ParticleTypeProperty("particle_type").configurable("ID of the particle you want to spawn.");
    public static final PalladiumProperty<String> OPTIONS = new StringProperty("options").configurable("Additional options for the particle (like color of a dust particle)");

    public ParticleAbility() {
        this.withProperty(PARTICLE_EMITTER, Collections.singletonList(new ResourceLocation("example:emitter"))).withProperty(PARTICLE, ParticleTypes.f_123805_).withProperty(OPTIONS, "");
    }

    @Override
    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && entity.m_9236_().f_46443_) {
            this.tickClient(entity, entry);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient(LivingEntity entity, AbilityInstance entry) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            try {
                ParticleType<?> type = entry.getProperty(PARTICLE);
                ParticleOptions options = type.m_123743_().m_5739_(type, new StringReader(" " + entry.getProperty(OPTIONS).trim() + " "));
                for (ResourceLocation id : entry.getProperty(PARTICLE_EMITTER)) {
                    ParticleEmitterConfiguration emitter = ParticleEmitterManager.INSTANCE.get(id);
                    if (emitter == null) continue;
                    emitter.spawnParticles(entity.m_9236_(), player, options, Minecraft.m_91087_().m_91297_());
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }
}

