/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.sound.AbilitySound;
import net.threetag.palladium.util.PlayerUtil;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;
import net.threetag.palladiumcore.util.Platform;

public class PlaySoundAbility
extends Ability {
    public static final PalladiumProperty<ResourceLocation> SOUND = new ResourceLocationProperty("sound").configurable("Sound ID that is being played");
    public static final PalladiumProperty<Float> VOLUME = new FloatProperty("volume").configurable("Volume for the played sound");
    public static final PalladiumProperty<Float> PITCH = new FloatProperty("pitch").configurable("Pitch for the played sound");
    public static final PalladiumProperty<Boolean> LOOPING = new BooleanProperty("looping").configurable("Whether or not the sound should loop during the time the ability is enabled");
    public static final PalladiumProperty<Boolean> PLAY_SELF = new BooleanProperty("play_self").configurable("Whether or not the sound should be played to just the player executing the ability, or to all players");
    public static final PalladiumProperty<Boolean> PLAY_OTHERS = new BooleanProperty("play_others").configurable("If 'play_self' is disabled, this determines whether or not the sound should be played to the players around the player executing the ability");

    public PlaySoundAbility() {
        this.withProperty(SOUND, new ResourceLocation("item.elytra.flying")).withProperty(VOLUME, Float.valueOf(1.0f)).withProperty(PITCH, Float.valueOf(1.0f)).withProperty(LOOPING, false).withProperty(PLAY_SELF, false).withProperty(PLAY_OTHERS, false);
    }

    @Override
    public String getDocumentationDescription() {
        return "Plays a sound when being enabled.";
    }

    @Override
    public boolean isEffect() {
        return true;
    }

    @Override
    public void firstTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            if (entry.getProperty(LOOPING).booleanValue()) {
                if (Platform.isClient() && entity.m_9236_().f_46443_) {
                    this.startSound(entity, entry);
                }
            } else if (!entity.m_9236_().f_46443_) {
                if (entry.getProperty(PLAY_SELF).booleanValue()) {
                    if (entity instanceof Player) {
                        Player player2 = (Player)entity;
                        PlayerUtil.playSound(player2, entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), entry.getProperty(SOUND), entity.m_5720_(), entry.getProperty(VOLUME).floatValue(), entry.getProperty(PITCH).floatValue());
                    }
                } else if (entry.getProperty(PLAY_OTHERS).booleanValue()) {
                    PlayerUtil.playSoundToAll(entity.m_9236_(), entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 100.0, entry.getProperty(SOUND), entity.m_5720_(), entry.getProperty(VOLUME).floatValue(), entry.getProperty(PITCH).floatValue(), player -> player != entity);
                } else {
                    PlayerUtil.playSoundToAll(entity.m_9236_(), entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 100.0, entry.getProperty(SOUND), entity.m_5720_(), entry.getProperty(VOLUME).floatValue(), entry.getProperty(PITCH).floatValue());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startSound(LivingEntity entity, AbilityInstance entry) {
        boolean play = entry.getProperty(PLAY_SELF) != false ? entity == Minecraft.m_91087_().f_91074_ : (entry.getProperty(PLAY_OTHERS) != false ? entity != Minecraft.m_91087_().f_91074_ : true);
        if (play) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new AbilitySound(entry.getReference(), entity, entry.getProperty(SOUND), entity.m_5720_(), entry.getProperty(VOLUME).floatValue(), entry.getProperty(PITCH).floatValue()));
        }
    }
}

