/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.accessory.RenderLayerAccessory;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.RenderLayerProviderAbility;
import net.threetag.palladium.util.property.AccessorySlotProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;

public class RenderLayerByAccessorySlotAbility
extends Ability
implements RenderLayerProviderAbility {
    public static final PalladiumProperty<ResourceLocation> DEFAULT = new ResourceLocationProperty("default_layer").configurable("ID of the render layer that will be used if none is specified in the accessory slot. Can be null.");
    public static final PalladiumProperty<AccessorySlot> SLOT = new AccessorySlotProperty("accessory_slot").configurable("ID of the slot that will be looked in for to get a render layer. There must be a render_layer accessory in it to get it from.");

    public RenderLayerByAccessorySlotAbility() {
        this.withProperty(DEFAULT, new ResourceLocation("namespace", "render_layer_id"));
        this.withProperty(SLOT, AccessorySlot.CHEST);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IPackRenderLayer getRenderLayer(AbilityInstance entry, LivingEntity entity, PackRenderLayerManager manager) {
        AtomicReference<ResourceLocation> layerId = new AtomicReference<ResourceLocation>(entry.getProperty(DEFAULT));
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Accessory.getPlayerData(player).ifPresent(data -> {
                AccessorySlot slot = entry.getProperty(SLOT);
                Map<AccessorySlot, Collection<Accessory>> slots = data.getSlots();
                if (slot != null && slots.containsKey(slot)) {
                    slots.get(slot).stream().filter(a -> a instanceof RenderLayerAccessory).findFirst().ifPresent(a -> layerId.set(((RenderLayerAccessory)a).renderLayerId));
                }
            });
        }
        return manager.getLayer(layerId.get());
    }
}

