/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;
import net.threetag.palladium.util.property.SyncType;
import net.threetag.palladiumcore.util.Platform;

public class ShaderEffectAbility
extends Ability {
    public static final PalladiumProperty<ResourceLocation> SHADER = new ResourceLocationProperty("shader").configurable("ID of the shader that shall be applied").sync(SyncType.SELF);

    public ShaderEffectAbility() {
        this.withProperty(SHADER, new ResourceLocation("shaders/post/creeper.json"));
    }

    @Override
    public boolean isEffect() {
        return true;
    }

    @Override
    public void firstTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && Platform.isClient()) {
            this.applyShader(entity, entry.getProperty(SHADER));
        }
    }

    @Override
    public void lastTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && Platform.isClient()) {
            this.removeShader(entity, entry.getProperty(SHADER));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyShader(LivingEntity entity, ResourceLocation shader) {
        Minecraft mc = Minecraft.m_91087_();
        if (entity == mc.f_91074_) {
            mc.f_91063_.m_109128_(shader);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void removeShader(LivingEntity entity, ResourceLocation shader) {
        Minecraft mc = Minecraft.m_91087_();
        if (entity == mc.f_91074_ && mc.f_91063_.m_109149_() != null && mc.f_91063_.m_109149_().m_110022_().equals(shader.toString())) {
            mc.f_91063_.m_109086_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation get(Player player) {
        Iterator<AbilityInstance> iterator = AbilityUtil.getEnabledEntries((LivingEntity)player, (Ability)Abilities.SHADER_EFFECT.get()).iterator();
        if (iterator.hasNext()) {
            AbilityInstance entry = iterator.next();
            return entry.getProperty(SHADER);
        }
        return null;
    }

    @Override
    public String getDocumentationDescription() {
        return "Allows you to apply a custom shader effect.";
    }
}

