/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.energybar;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.energybar.EnergyBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyBarReference {
    @Nullable
    private final ResourceLocation powerId;
    @NotNull
    private final String energyBarName;

    public EnergyBarReference(@Nullable ResourceLocation powerId, @NotNull String energyBarName) {
        this.powerId = powerId;
        this.energyBarName = energyBarName;
    }

    public static EnergyBarReference fromString(String parse) {
        String[] s = parse.split("#", 2);
        if (s.length == 1) {
            return new EnergyBarReference(null, s[0]);
        }
        return new EnergyBarReference(new ResourceLocation(s[0]), s[1]);
    }

    @Nullable
    public ResourceLocation getPowerId() {
        return this.powerId;
    }

    @NotNull
    public String getEnergyBarName() {
        return this.energyBarName;
    }

    @Nullable
    public EnergyBar getEntry(LivingEntity entity) {
        return this.getEntry(entity, null);
    }

    @Nullable
    public EnergyBar getEntry(LivingEntity entity, @Nullable IPowerHolder powerHolder) {
        if (this.powerId != null) {
            IPowerHandler handler = PowerManager.getPowerHandler(entity).orElse(null);
            Power power = PowerManager.getInstance(entity.m_9236_()).getPower(this.powerId);
            powerHolder = power != null && handler != null ? handler.getPowerHolder(power) : null;
        }
        if (powerHolder != null) {
            return powerHolder.getEnergyBars().get(this.energyBarName);
        }
        return null;
    }

    public Optional<EnergyBar> optional(LivingEntity entity, @Nullable IPowerHolder powerHolder) {
        return Optional.ofNullable(this.getEntry(entity, powerHolder));
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.m_236821_((Object)this.powerId, (buf1, resourceLocation) -> buf.m_130085_(resourceLocation));
        buf.m_130070_(this.energyBarName);
    }

    public static EnergyBarReference fromBuffer(FriendlyByteBuf buf) {
        return new EnergyBarReference((ResourceLocation)buf.m_236868_(FriendlyByteBuf::m_130281_), buf.m_130277_());
    }

    public String toString() {
        if (this.powerId == null) {
            return this.energyBarName;
        }
        return String.valueOf(this.powerId) + "#" + this.energyBarName;
    }

    public int hashCode() {
        return Objects.hash(this.powerId, this.energyBarName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnergyBarReference)) {
            return false;
        }
        EnergyBarReference that = (EnergyBarReference)o;
        return Objects.equals(this.powerId, that.powerId) && Objects.equals(this.energyBarName, that.energyBarName);
    }
}

