/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.provider;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerValidator;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerCollector;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.provider.PowerProvider;
import net.threetag.palladium.util.property.PalladiumProperties;

public class SuperpowerProvider
extends PowerProvider {
    @Override
    public void providePowers(LivingEntity entity, IPowerHandler handler, PowerCollector collector) {
        for (ResourceLocation id : PalladiumProperties.SUPERPOWER_IDS.get((Entity)entity)) {
            Power power = PowerManager.getInstance(entity.m_9236_()).getPower(id);
            collector.addPower(power, Validator::new);
        }
    }

    public static class Validator
    implements IPowerValidator {
        @Override
        public boolean stillValid(LivingEntity entity, Power power) {
            List<ResourceLocation> stored = PalladiumProperties.SUPERPOWER_IDS.get((Entity)entity);
            return stored != null && stored.contains(power.getId());
        }
    }
}

