/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDefinition;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.client.model.ExtendedCubeListBuilder;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BedrockModelUtil {
    public static LayerDefinition parseAsLayerDefinition(JsonObject json) {
        JsonArray geometry = GsonHelper.m_13933_((JsonObject)json, (String)"minecraft:geometry");
        if (geometry.isEmpty()) {
            throw new JsonParseException("Empty geometry!");
        }
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        JsonObject geo = GsonHelper.m_13918_((JsonElement)geometry.get(0), (String)"minecraft:geometry[].$");
        JsonObject description = GsonHelper.m_13841_((JsonObject)geo, (String)"description", (JsonObject)new JsonObject());
        int textureWidth = GsonHelper.m_13927_((JsonObject)description, (String)"texture_width");
        int textureHeight = GsonHelper.m_13927_((JsonObject)description, (String)"texture_height");
        JsonArray bones = GsonHelper.m_13832_((JsonObject)geo, (String)"bones", (JsonArray)new JsonArray());
        HashMap<String, BedrockModelPartCache> cache = new HashMap<String, BedrockModelPartCache>();
        HashMap<String, PartDefinition> modelParts = new HashMap<String, PartDefinition>();
        for (JsonElement b : bones) {
            JsonObject bone = GsonHelper.m_13918_((JsonElement)b, (String)"minecraft:geomeotry[].bones.$");
            String name = GsonHelper.m_13906_((JsonObject)bone, (String)"name");
            String parent = GsonHelper.m_13851_((JsonObject)bone, (String)"parent", null);
            float[] pivot = GsonUtil.getFloatArray(bone, 3, "pivot", 0.0f, 0.0f, 0.0f);
            float[] rotation = GsonUtil.getFloatArray(bone, 3, "rotation", 0.0f, 0.0f, 0.0f);
            JsonArray cubesJson = GsonHelper.m_13832_((JsonObject)bone, (String)"cubes", (JsonArray)new JsonArray());
            ArrayList<BedrockModelCube> cubes = new ArrayList<BedrockModelCube>();
            for (JsonElement cj : cubesJson) {
                JsonObject cubeJson = GsonHelper.m_13918_((JsonElement)cj, (String)"minecraft:geomeotry[].bones[].cubes[].$");
                float[] origin = GsonUtil.getFloatArray(cubeJson, 3, "origin");
                float[] size = GsonUtil.getFloatArray(cubeJson, 3, "size");
                float inflate = GsonHelper.m_13820_((JsonObject)cubeJson, (String)"inflate", (float)0.0f);
                JsonElement uvJson = cubeJson.get("uv");
                boolean mirror = GsonHelper.m_13855_((JsonObject)cubeJson, (String)"mirror", (boolean)false);
                if (uvJson.isJsonArray()) {
                    int[] uv = GsonUtil.getIntArray(cubeJson, 2, "uv", 0, 0);
                    cubes.add(new BedrockModelCube(new Vector3f(origin[0], origin[1], origin[2]), new Vector3f(size[0], size[1], size[2]), inflate, mirror, new UVPair((float)uv[0], (float)uv[1])));
                    continue;
                }
                JsonObject uvs = GsonHelper.m_13918_((JsonElement)uvJson, (String)"minecraft:geomeotry[].bones[].cubes[].uv");
                HashMap<Direction, ExtendedCubeListBuilder.PerFaceUV> uvMap = new HashMap<Direction, ExtendedCubeListBuilder.PerFaceUV>();
                for (Direction direction : Direction.values()) {
                    if (!GsonHelper.m_13900_((JsonObject)uvs, (String)direction.m_122433_())) continue;
                    JsonObject directionJson = GsonHelper.m_13930_((JsonObject)uvs, (String)direction.m_122433_());
                    int[] uv = GsonUtil.getIntArray(directionJson, 2, "uv", 0, 0);
                    int[] uvSize = GsonUtil.getIntArray(directionJson, 2, "uv_size", 0, 0);
                    uvMap.put(direction.m_122434_() == Direction.Axis.Z ? direction : direction.m_122424_(), new ExtendedCubeListBuilder.PerFaceUV(new UVPair((float)uv[0], (float)uv[1]), new UVPair((float)uvSize[0], (float)uvSize[1])));
                }
                cubes.add(new BedrockModelCube(new Vector3f(origin[0], origin[1], origin[2]), new Vector3f(size[0], size[1], size[2]), inflate, mirror, uvMap));
            }
            cache.put(name, new BedrockModelPartCache(name, parent, new Vector3f(pivot[0], pivot[1], pivot[2]), new Vector3f((float)Math.toRadians(rotation[0]), (float)Math.toRadians(rotation[1]), (float)Math.toRadians(rotation[2])), cubes));
        }
        for (Map.Entry e : cache.entrySet()) {
            if (((BedrockModelPartCache)e.getValue()).parentName == null) continue;
            if (!cache.containsKey(((BedrockModelPartCache)e.getValue()).parentName)) {
                throw new JsonParseException("Unknown parent '" + ((BedrockModelPartCache)e.getValue()).parentName + "'");
            }
            ((BedrockModelPartCache)e.getValue()).parent = (BedrockModelPartCache)cache.get(((BedrockModelPartCache)e.getValue()).parentName);
            ((BedrockModelPartCache)cache.get((Object)((BedrockModelPartCache)e.getValue()).parentName)).children.add((BedrockModelPartCache)e.getValue());
        }
        while (!cache.isEmpty()) {
            HashMap copy = new HashMap(cache);
            for (Map.Entry e : copy.entrySet()) {
                if (((BedrockModelPartCache)e.getValue()).parentName == null) {
                    BedrockModelUtil.convertHierarchy((BedrockModelPartCache)e.getValue(), "");
                    modelParts.put((String)e.getKey(), ((BedrockModelPartCache)e.getValue()).add(root));
                    cache.remove(e.getKey());
                    continue;
                }
                PartDefinition parent = (PartDefinition)modelParts.get(((BedrockModelPartCache)e.getValue()).parentName);
                if (parent == null) continue;
                modelParts.put((String)e.getKey(), ((BedrockModelPartCache)e.getValue()).add(parent));
                cache.remove(e.getKey());
            }
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)textureWidth, (int)textureHeight);
    }

    private static void convertHierarchy(BedrockModelPartCache part, String prefix) {
        part.convert();
        for (BedrockModelPartCache child : part.children) {
            BedrockModelUtil.convertHierarchy(child, prefix + "  ");
        }
    }

    public static JsonObject toJsonModel(LayerDefinition layerDefinition, @Nullable String identifier) {
        JsonObject json = new JsonObject();
        json.addProperty("format_version", "1.12.0");
        JsonArray geometryArray = new JsonArray();
        JsonObject geometry = new JsonObject();
        JsonObject description = new JsonObject();
        description.addProperty("identifier", identifier != null ? identifier : "geometry.unknown");
        description.addProperty("texture_width", (Number)layerDefinition.f_171560_.f_171569_);
        description.addProperty("texture_height", (Number)layerDefinition.f_171560_.f_171570_);
        geometry.add("description", (JsonElement)description);
        JsonArray bones = new JsonArray();
        layerDefinition.f_171559_.m_171576_().f_171579_.forEach((s, part) -> BedrockModelUtil.addBoneToArray(bones, s, part, new ArrayList<PartDefinition>(), null));
        geometry.add("bones", (JsonElement)bones);
        geometryArray.add((JsonElement)geometry);
        json.add("minecraft:geometry", (JsonElement)geometryArray);
        return json;
    }

    private static void addBoneToArray(JsonArray array, String name, PartDefinition part, List<PartDefinition> parents, @Nullable String parent) {
        JsonObject json = new JsonObject();
        json.addProperty("name", name);
        if (parent != null) {
            json.addProperty("parent", parent);
        }
        Vector3f fixedPivot = new Vector3f(part.f_171578_.f_171405_, part.f_171578_.f_171406_, part.f_171578_.f_171407_);
        for (PartDefinition partDefinition : parents) {
            fixedPivot.add(partDefinition.f_171578_.f_171405_, partDefinition.f_171578_.f_171406_, partDefinition.f_171578_.f_171407_);
        }
        fixedPivot.sub(0.0f, 24.0f, 0.0f).mul(1.0f, -1.0f, 1.0f);
        json.add("pivot", (JsonElement)BedrockModelUtil.vec3ToJsonArray(fixedPivot));
        json.add("rotation", (JsonElement)BedrockModelUtil.vec3ToJsonArray(Math.toDegrees(part.f_171578_.f_171408_), Math.toDegrees(part.f_171578_.f_171409_), Math.toDegrees(part.f_171578_.f_171410_)));
        JsonArray cubes = new JsonArray();
        for (CubeDefinition c : part.f_171577_) {
            JsonObject cube = new JsonObject();
            Vector3f fixedOrigin = new Vector3f().set((Vector3fc)c.f_171435_).add(fixedPivot.x, 0.0f, fixedPivot.z);
            fixedOrigin.y = (fixedOrigin.y + c.f_171436_.y - fixedPivot.y) * -1.0f;
            cube.add("origin", (JsonElement)BedrockModelUtil.vec3ToJsonArray(fixedOrigin));
            cube.add("size", (JsonElement)BedrockModelUtil.vec3ToJsonArray(c.f_171436_));
            cube.addProperty("inflate", (Number)((double)(c.f_171437_.f_171459_ + c.f_171437_.f_171460_ + c.f_171437_.f_171461_) / 3.0));
            if (c instanceof ExtendedCubeListBuilder.PerFaceCubeDefinition) {
                ExtendedCubeListBuilder.PerFaceCubeDefinition perFace = (ExtendedCubeListBuilder.PerFaceCubeDefinition)c;
                JsonObject uv = new JsonObject();
                for (Map.Entry<Direction, ExtendedCubeListBuilder.PerFaceUV> e : perFace.uvMap.entrySet()) {
                    JsonObject face = new JsonObject();
                    Direction direction = e.getKey();
                    face.add("uv", (JsonElement)BedrockModelUtil.uvPairToJsonArray(e.getValue().uv()));
                    face.add("uv_size", (JsonElement)BedrockModelUtil.uvPairToJsonArray(e.getValue().size()));
                    uv.add(direction.m_122434_() == Direction.Axis.Z ? direction.m_122433_() : direction.m_122424_().m_122433_(), (JsonElement)face);
                }
                cube.add("uv", (JsonElement)uv);
            } else {
                cube.add("uv", (JsonElement)BedrockModelUtil.uvPairToJsonArray(c.f_171439_));
            }
            cube.addProperty("mirror", Boolean.valueOf(c.f_171438_));
            cubes.add((JsonElement)cube);
        }
        json.add("cubes", (JsonElement)cubes);
        array.add((JsonElement)json);
        ArrayList<PartDefinition> arrayList = new ArrayList<PartDefinition>(parents);
        arrayList.add(part);
        part.f_171579_.forEach((n, p) -> BedrockModelUtil.addBoneToArray(array, n, p, newParents, name));
    }

    private static JsonArray vec3ToJsonArray(Vector3f vec) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(vec.x));
        array.add((Number)Float.valueOf(vec.y));
        array.add((Number)Float.valueOf(vec.z));
        return array;
    }

    private static JsonArray vec3ToJsonArray(double x, double y, double z) {
        JsonArray array = new JsonArray();
        array.add((Number)x);
        array.add((Number)y);
        array.add((Number)z);
        return array;
    }

    private static JsonArray uvPairToJsonArray(UVPair uv) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(uv.m_171612_()));
        array.add((Number)Float.valueOf(uv.m_171613_()));
        return array;
    }

    public static class BedrockModelCube {
        private final Vector3f origin;
        private final Vector3f size;
        private final float inflate;
        private final UVPair uv;
        private final Map<Direction, ExtendedCubeListBuilder.PerFaceUV> uvMap;
        private final boolean mirror;

        public BedrockModelCube(Vector3f origin, Vector3f size, float inflate, boolean mirror, UVPair uv) {
            this.origin = origin;
            this.size = size;
            this.inflate = inflate;
            this.mirror = mirror;
            this.uv = uv;
            this.uvMap = null;
        }

        public BedrockModelCube(Vector3f origin, Vector3f size, float inflate, boolean mirror, Map<Direction, ExtendedCubeListBuilder.PerFaceUV> uvMap) {
            this.origin = origin;
            this.size = size;
            this.inflate = inflate;
            this.mirror = mirror;
            this.uv = null;
            this.uvMap = uvMap;
        }

        public void add(ExtendedCubeListBuilder builder) {
            if (this.uv != null) {
                builder.m_171555_(this.mirror).m_171514_((int)this.uv.m_171612_(), (int)this.uv.m_171613_()).m_171488_(this.origin.x, this.origin.y, this.origin.z, this.size.x, this.size.y, this.size.z, new CubeDeformation(this.inflate));
            } else {
                ExtendedCubeListBuilder.PerFaceCubeBuilder cubeBuilder = builder.addPerFaceUVCube().origin(this.origin).dimensions(this.size).grow(this.inflate);
                for (Map.Entry<Direction, ExtendedCubeListBuilder.PerFaceUV> e : Objects.requireNonNull(this.uvMap).entrySet()) {
                    cubeBuilder.addFace(e.getKey(), e.getValue().uv(), e.getValue().size());
                }
                cubeBuilder.build();
            }
        }

        public void convert(Vector3f pivot, String name) {
            this.origin.sub(pivot.x, 0.0f, pivot.z);
            this.origin.y = pivot.y - this.origin.y - this.size.y;
        }
    }

    public static class BedrockModelPartCache {
        private final String name;
        @Nullable
        public final String parentName;
        public BedrockModelPartCache parent;
        public List<BedrockModelPartCache> children = new ArrayList<BedrockModelPartCache>();
        private final Vector3f unconvertedPivot;
        private final Vector3f pivot;
        private final Vector3f rotation;
        private final List<BedrockModelCube> cubes;

        public BedrockModelPartCache(String name, @Nullable String parentName, Vector3f pivot, Vector3f rotation, List<BedrockModelCube> cubes) {
            this.name = name;
            this.parentName = parentName;
            this.unconvertedPivot = pivot;
            this.pivot = pivot;
            this.rotation = rotation;
            this.cubes = cubes;
        }

        public PartDefinition add(PartDefinition parent) {
            ExtendedCubeListBuilder builder = ExtendedCubeListBuilder.create();
            for (BedrockModelCube cube : this.cubes) {
                cube.add(builder);
            }
            return parent.m_171599_(this.name, (CubeListBuilder)builder, PartPose.m_171423_((float)this.pivot.x, (float)this.pivot.y, (float)this.pivot.z, (float)this.rotation.x, (float)this.rotation.y, (float)this.rotation.z));
        }

        public BedrockModelPartCache convert() {
            this.cubes.forEach(c -> c.convert(this.pivot, this.name));
            this.pivot.mul(1.0f, -1.0f, 1.0f).add(0.0f, 24.0f, 0.0f);
            BedrockModelPartCache parent = this.parent;
            while (parent != null) {
                this.pivot.sub((Vector3fc)parent.unconvertedPivot);
                parent = parent.parent;
            }
            return this;
        }
    }
}

