/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.entity.EffectEntity;
import net.threetag.palladium.entity.PalladiumEntityExtension;
import net.threetag.palladium.entity.TrailSegmentEntity;
import net.threetag.palladium.util.MathUtil;
import org.jetbrains.annotations.Nullable;

public class EntityUtil {
    public static boolean isMoving(Entity entity) {
        if (entity instanceof PalladiumEntityExtension) {
            PalladiumEntityExtension ext = (PalladiumEntityExtension)entity;
            return ext.palladium$getLastTickPos().m_82554_(entity.m_20182_()) != 0.0;
        }
        return false;
    }

    public static Vec3 getLookVector(Entity entity) {
        return MathUtil.calculateViewVector(entity.m_146909_(), entity.m_6080_());
    }

    public static Vec3 getLookVector(Entity entity, float partialTicks) {
        float f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            f = Mth.m_14179_((float)partialTicks, (float)livingEntity.f_20886_, (float)livingEntity.f_20885_);
        } else {
            f = entity.m_6080_();
        }
        float headRot = f;
        return MathUtil.calculateViewVector(entity.m_5686_(partialTicks), headRot);
    }

    public static HitResult rayTraceWithEntities(Entity entityIn, double distance, ClipContext.Block blockModeIn, ClipContext.Fluid fluidModeIn) {
        return EntityUtil.rayTraceWithEntities(entityIn, null, null, distance, blockModeIn, fluidModeIn, e -> true);
    }

    public static HitResult rayTraceWithEntities(Entity entityIn, @Nullable Vec3 startVec, @Nullable Vec3 endVec, double distance, ClipContext.Block blockModeIn, ClipContext.Fluid fluidModeIn, Predicate<Entity> entityPredicate) {
        Vec3 lookVec = EntityUtil.getLookVector(entityIn);
        startVec = startVec == null ? entityIn.m_20182_().m_82520_(0.0, (double)entityIn.m_20192_(), 0.0) : startVec;
        endVec = endVec == null ? startVec.m_82549_(lookVec.m_82490_(distance)) : endVec;
        BlockHitResult blockResult = entityIn.m_9236_().m_45547_(new ClipContext(startVec, endVec, blockModeIn, fluidModeIn, entityIn));
        EntityHitResult entityResult = null;
        int i = 0;
        while ((double)i < distance * 2.0 && entityResult == null) {
            float scale = (float)i / 2.0f;
            Vec3 pos = startVec.m_82549_(lookVec.m_82490_((double)scale));
            Vec3 min = pos.m_82520_(0.25, 0.25, 0.25);
            Vec3 max = pos.m_82520_(-0.25, -0.25, -0.25);
            for (Entity entity : entityIn.m_9236_().m_45933_(entityIn, new AABB(min.f_82479_, min.f_82480_, min.f_82481_, max.f_82479_, max.f_82480_, max.f_82481_))) {
                if (!EntityUtil.canBeTraced(entity) || !entityPredicate.test(entity)) continue;
                entityResult = new EntityHitResult(entity, pos);
                break;
            }
            ++i;
        }
        if (entityResult != null && entityResult.m_82450_().m_82554_(startVec) <= blockResult.m_82450_().m_82554_(startVec)) {
            return entityResult;
        }
        return blockResult;
    }

    public static boolean canBeTraced(Entity entity) {
        if (entity instanceof AreaEffectCloud) {
            return false;
        }
        if (entity instanceof TrailSegmentEntity) {
            return false;
        }
        return !(entity instanceof EffectEntity);
    }
}

