/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GuiUtil {
    public static void drawItem(GuiGraphics graphics, ItemStack stack, int hash, boolean renderOverlay, @Nullable String text) {
        boolean flatLight;
        if (stack.m_41619_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer itemRenderer = mc.m_91291_();
        BakedModel bakedModel = itemRenderer.m_174264_(stack, null, (LivingEntity)mc.f_91074_, hash);
        Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_252931_(graphics.m_280168_().m_85850_().m_252922_());
        modelViewStack.m_85841_(1.0f, -1.0f, 1.0f);
        modelViewStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flatLight = !bakedModel.m_7547_();
        if (flatLight) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(stack, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            Lighting.m_84931_();
        }
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        if (renderOverlay) {
            float cooldown;
            Tesselator t = Tesselator.m_85913_();
            Font font = mc.f_91062_;
            if (stack.m_41613_() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.m_41613_()) : text;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85837_(9.0 - (double)font.m_92895_(s), 1.0, 20.0);
                font.m_271703_(s, 0.0f, 0.0f, 0xFFFFFF, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                bufferSource.m_109911_();
                graphics.m_280168_().m_85849_();
            }
            if (stack.m_150947_()) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                int barWidth = stack.m_150948_();
                int barColor = stack.m_150949_();
                GuiUtil.draw(graphics, t, -6, 5, 13, 2, 0, 0, 0, 255);
                GuiUtil.draw(graphics, t, -6, 5, barWidth, 1, barColor >> 16 & 0xFF, barColor >> 8 & 0xFF, barColor & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
            }
            float f = cooldown = mc.f_91074_ == null ? 0.0f : mc.f_91074_.m_36335_().m_41521_(stack.m_41720_(), mc.m_91296_());
            if (cooldown > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                GuiUtil.draw(graphics, t, -8, Mth.m_14143_((float)(16.0f * (1.0f - cooldown))) - 8, 16, Mth.m_14167_((float)(16.0f * cooldown)), 255, 255, 255, 127);
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void draw(GuiGraphics graphics, Tesselator t, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        if (width <= 0 || height <= 0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder renderer = t.m_85915_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_252986_(m, (float)x, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_252986_(m, (float)x, (float)(y + height), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_252986_(m, (float)(x + width), (float)(y + height), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_252986_(m, (float)(x + width), (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        t.m_85914_();
    }

    public static void drawContinuousTexturedBox(PoseStack poseStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int borderSize, float zLevel) {
        GuiUtil.drawContinuousTexturedBox(poseStack, x, y, u, v, width, height, textureWidth, textureHeight, borderSize, borderSize, borderSize, borderSize, zLevel);
    }

    public static void drawContinuousTexturedBox(PoseStack poseStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GuiUtil.drawTexturedModalRect(poseStack, x, y, u, v, leftBorder, topBorder, zLevel);
        GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        GuiUtil.drawTexturedModalRect(poseStack, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtil.drawTexturedModalRect(poseStack, x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public static void drawTexturedModalRect(PoseStack poseStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder wr = tessellator.m_85915_();
        wr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        wr.m_252986_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)x, (float)y, zLevel).m_7421_((float)u * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        tessellator.m_85914_();
    }
}

