/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModelLayerLocationUtil {
    private final ResourceLocation model;
    private final String layer;

    public ModelLayerLocationUtil(ResourceLocation model, String layer) {
        this.model = model;
        this.layer = layer;
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public String getLayer() {
        return this.layer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelLayerLocation toModelLayer() {
        return new ModelLayerLocation(this.model, this.layer);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ModelLayerLocationUtil)) {
            return false;
        }
        ModelLayerLocationUtil modelLayerLocation = (ModelLayerLocationUtil)object;
        return this.model.equals((Object)modelLayerLocation.model) && this.layer.equals(modelLayerLocation.layer);
    }

    public int hashCode() {
        int i = this.model.hashCode();
        i = 31 * i + this.layer.hashCode();
        return i;
    }

    public String toString() {
        return String.valueOf(this.model) + "#" + this.layer;
    }
}

