/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class SplashTextUtil {
    private static final List<Triple<Integer, Integer, String>> DATED = new ArrayList<Triple<Integer, Integer, String>>();
    private static final List<Pair<Integer, String>> RANDOM = new ArrayList<Pair<Integer, String>>();

    public static void addRandom(int rarity, String splash) {
        RANDOM.add((Pair<Integer, String>)Pair.of((Object)rarity, (Object)splash));
    }

    public static void addDated(int day, int month, String splash) {
        DATED.add((Triple<Integer, Integer, String>)Triple.of((Object)day, (Object)month, (Object)splash));
    }

    @Nullable
    public static String getPossibleOverrideSplash() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        for (Triple<Integer, Integer, String> triple : DATED) {
            if ((Integer)triple.getLeft() != day || (Integer)triple.getMiddle() != month) continue;
            return (String)triple.getRight();
        }
        Random random = new Random();
        for (Pair<Integer, String> pair : RANDOM) {
            if (random.nextInt((Integer)pair.getFirst()) != 0) continue;
            return (String)pair.getSecond();
        }
        return null;
    }

    static {
        SplashTextUtil.addDated(20, 12, "Happy birthday, Lucraft!");
        SplashTextUtil.addDated(16, 7, "Happy birthday, Sheriff!");
        SplashTextUtil.addDated(27, 10, "Happy birthday, Connor!");
        SplashTextUtil.addDated(16, 1, "i hate u habb");
        SplashTextUtil.addRandom(300, "Also try FiskHeroes!");
    }
}

