/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessoryPlayerData;
import net.threetag.palladiumcore.event.PlayerEvents;
import net.threetag.palladiumcore.util.Platform;
import org.jetbrains.annotations.Nullable;

public class SupporterHandler {
    private static final String BASE_URL = "https://squirrelcontrol.threetag.net/api/";
    private static final Map<UUID, PlayerData> DATA = Maps.newHashMap();
    private static boolean CHECK = false;

    public static void init() {
        PlayerEvents.JOIN.register(player -> {
            SupporterHandler.loadPlayerData(player.m_20148_());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (CHECK && !SupporterHandler.getPlayerData(player.m_20148_()).hasModAccess()) {
                    serverPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)"You are not allowed to use this mod!"));
                }
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit() {
        PlayerEvents.CLIENT_JOIN.register(player -> SupporterHandler.loadPlayerData(player.m_20148_()));
        PlayerEvents.CLIENT_QUIT.register(player -> {
            if (player != null) {
                DATA.remove(player.m_20148_());
            }
        });
    }

    public static void loadPlayerData(UUID uuid) {
        CompletableFuture.runAsync(() -> {
            try {
                ServerPlayer player;
                JsonObject json = SupporterHandler.readJsonFromUrl("https://squirrelcontrol.threetag.net/api/player/" + uuid.toString());
                PlayerData data = new PlayerData(uuid, GsonHelper.m_13930_((JsonObject)json, (String)"data"));
                DATA.put(uuid, data);
                Palladium.LOGGER.info("Successfully read user's supporter data! ({})", (Object)uuid);
                if (Platform.getCurrentServer() != null && (player = Platform.getCurrentServer().m_6846_().m_11259_(uuid)) != null) {
                    Accessory.getPlayerData((Player)player).ifPresent(arg_0 -> SupporterHandler.lambda$loadPlayerData$3((Player)player, arg_0));
                }
                return;
            }
            catch (Exception e) {
                if (!Platform.isProduction()) {
                    Palladium.LOGGER.warn("Was not able to read user's supporter data! ({})", (Object)uuid.toString());
                }
                PlayerData data = new PlayerData(uuid, new JsonObject());
                DATA.put(uuid, data);
                return;
            }
        }, Util.m_183991_()).join();
    }

    public static void enableSupporterCheck() {
        if (!CHECK) {
            CHECK = true;
            Palladium.LOGGER.info("The supporter check has been enabled!");
        }
    }

    public static boolean isSupporterCheckEnabled() {
        return CHECK;
    }

    public static PlayerData getPlayerData(UUID uuid) {
        if (DATA.containsKey(uuid)) {
            return DATA.get(uuid);
        }
        PlayerData data = new PlayerData(uuid, new JsonObject());
        DATA.put(uuid, data);
        return data;
    }

    public static PlayerData getPlayerDataUnsafe(UUID uuid) {
        return DATA.get(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject readJsonFromUrl(String url) throws Exception {
        try (InputStream is = new URL(url).openStream();){
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            JsonObject json = new JsonParser().parse((Reader)rd).getAsJsonObject();
            if (GsonHelper.m_13927_((JsonObject)json, (String)"error") != 200) {
                throw new Exception("Error while reading json: " + GsonHelper.m_13906_((JsonObject)json, (String)"message"));
            }
            JsonObject jsonObject = json;
            return jsonObject;
        }
    }

    private static /* synthetic */ void lambda$loadPlayerData$3(Player player, AccessoryPlayerData accessoryData) {
        accessoryData.validate(player);
    }

    public static class PlayerData {
        private final UUID uuid;
        private final List<Accessory> accessories;
        private final boolean modAccess;
        private final boolean hasCloak;
        private ResourceLocation cloakTexture;

        public PlayerData(UUID uuid, JsonObject json) {
            this.uuid = uuid;
            this.accessories = new ArrayList<Accessory>();
            JsonArray data = GsonHelper.m_13832_((JsonObject)json, (String)"accessoires", (JsonArray)new JsonArray());
            for (int i = 0; i < data.size(); ++i) {
                ResourceLocation id = new ResourceLocation(data.get(i).getAsString());
                if (id.m_135827_().equalsIgnoreCase("threecore")) {
                    id = Palladium.id(id.m_135815_());
                }
                if (!Accessory.REGISTRY.containsKey(id)) continue;
                this.accessories.add((Accessory)Accessory.REGISTRY.get(id));
            }
            this.modAccess = GsonHelper.m_13855_((JsonObject)json, (String)"mod_access", (boolean)false);
            if (GsonHelper.m_13900_((JsonObject)json, (String)"cloak")) {
                this.hasCloak = true;
                if (Platform.isClient()) {
                    this.loadCloakTexture(GsonHelper.m_13906_((JsonObject)json, (String)"cloak"));
                }
            } else {
                this.hasCloak = false;
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void loadCloakTexture(String url) {
            if (RenderSystem.isOnRenderThread()) {
                try {
                    ResourceLocation resourceLocation = Palladium.id("cloaks/" + this.uuid.toString());
                    Minecraft.m_91087_().m_91097_().m_118513_(resourceLocation);
                    InputStream stream = new URL(url).openStream();
                    NativeImage image = NativeImage.m_85058_((InputStream)stream);
                    Minecraft.m_91087_().m_91097_().m_118495_(resourceLocation, (AbstractTexture)new DynamicTexture(image));
                    stream.close();
                    this.cloakTexture = resourceLocation;
                }
                catch (IOException e) {
                    Palladium.LOGGER.error("Error loading supporter cloak texture: " + e.getMessage());
                }
            }
        }

        public boolean hasModAccess() {
            return this.modAccess;
        }

        public boolean hasAccessory(Accessory accessory) {
            return this.accessories.contains(accessory) || !Platform.isProduction();
        }

        public List<Accessory> getAccessories() {
            return ImmutableList.copyOf(this.accessories);
        }

        public boolean hasCloak() {
            return this.hasCloak;
        }

        @Nullable
        public ResourceLocation getCloakTexture() {
            return this.cloakTexture;
        }
    }
}

