/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.context;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.context.DataContextType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataContext {
    private final Map<DataContextType<?>, Object> values = new HashMap();

    private DataContext() {
    }

    public static DataContext create() {
        return new DataContext();
    }

    public static DataContext forEntity(Entity entity) {
        return DataContext.create().with(DataContextType.ENTITY, entity).with(DataContextType.LEVEL, entity.m_9236_());
    }

    public static DataContext forArmorInSlot(LivingEntity entity, EquipmentSlot slot) {
        return DataContext.forEntity((Entity)entity).with(DataContextType.SLOT, slot).with(DataContextType.ITEM, entity.m_6844_(slot));
    }

    public static DataContext forItem(Entity entity, ItemStack stack) {
        return DataContext.forEntity(entity).with(DataContextType.ITEM, stack);
    }

    public static DataContext forPower(LivingEntity entity, IPowerHolder powerHolder) {
        DataContext context = DataContext.forEntity((Entity)entity);
        if (powerHolder != null) {
            context.with(DataContextType.POWER_HOLDER, powerHolder);
            context.with(DataContextType.POWER, powerHolder.getPower());
        }
        return context;
    }

    public static DataContext forAbility(LivingEntity entity, AbilityInstance abilityInstance) {
        DataContext context = DataContext.forEntity((Entity)entity);
        if (abilityInstance != null) {
            context.with(DataContextType.ABILITY, abilityInstance);
            context.with(DataContextType.POWER_HOLDER, abilityInstance.getHolder());
            context.with(DataContextType.POWER, abilityInstance.getHolder().getPower());
        }
        return context;
    }

    public <T> DataContext with(DataContextType<T> type, T value) {
        this.values.put(type, value);
        return this;
    }

    public <T> T get(DataContextType<T> type) {
        return (T)this.values.get(type);
    }

    public boolean has(DataContextType<?> type) {
        return this.values.containsKey(type);
    }

    public DataContext copy() {
        DataContext context = new DataContext();
        context.values.putAll(this.values);
        return context;
    }

    @Nullable
    public Entity getEntity() {
        return this.get(DataContextType.ENTITY);
    }

    @Nullable
    public LivingEntity getLivingEntity() {
        LivingEntity living;
        Entity entity = this.getEntity();
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    @Nullable
    public Player getPlayer() {
        Player player;
        Entity entity = this.getEntity();
        return entity instanceof Player ? (player = (Player)entity) : null;
    }

    @Nullable
    public Level getLevel() {
        return this.get(DataContextType.LEVEL);
    }

    @NotNull
    public ItemStack getItem() {
        return this.has(DataContextType.ITEM) ? this.get(DataContextType.ITEM) : ItemStack.f_41583_;
    }

    @Nullable
    public EquipmentSlot getSlot() {
        return this.get(DataContextType.SLOT);
    }

    @Nullable
    public AbilityInstance getAbility() {
        return this.get(DataContextType.ABILITY);
    }

    @Nullable
    public Power getPower() {
        return this.get(DataContextType.POWER);
    }

    @Nullable
    public IPowerHolder getPowerHolder() {
        return this.get(DataContextType.POWER_HOLDER);
    }
}

