/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.GuiUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;

public record IngredientIcon(Ingredient ingredient) implements IIcon
{
    @Override
    public void draw(Minecraft mc, GuiGraphics guiGraphics, DataContext context, int x, int y, int width, int height) {
        PoseStack stack = guiGraphics.m_280168_();
        stack.m_85836_();
        stack.m_85837_((double)x + (double)width / 2.0, (double)y + (double)height / 2.0, 100.0);
        if (width != 16 || height != 16) {
            int s = Math.min(width, height);
            stack.m_85841_((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
        }
        int stackIndex = (int)(System.currentTimeMillis() / 1000L % (long)this.ingredient.m_43908_().length);
        GuiUtil.drawItem(guiGraphics, this.ingredient.m_43908_()[stackIndex], 0, true, null);
        stack.m_85849_();
    }

    public IconSerializer<IngredientIcon> getSerializer() {
        return (IconSerializer)IconSerializers.INGREDIENT.get();
    }

    @Override
    public String toString() {
        return "IngredientIcon{ingredient=" + String.valueOf(this.ingredient.m_43942_()) + "}";
    }

    public static class Serializer
    extends IconSerializer<IngredientIcon> {
        @Override
        public IngredientIcon fromJSON(JsonObject json) {
            return new IngredientIcon(Ingredient.m_43917_((JsonElement)json.get("ingredient")));
        }

        @Override
        public IngredientIcon fromNBT(CompoundTag nbt) {
            return new IngredientIcon(Ingredient.m_43917_((JsonElement)GsonHelper.m_13864_((String)nbt.m_128461_("Ingredient"))));
        }

        @Override
        public JsonObject toJSON(IngredientIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("ingredient", icon.ingredient.m_43942_());
            return jsonObject;
        }

        @Override
        public CompoundTag toNBT(IngredientIcon icon) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Ingredient", icon.ingredient.m_43942_().toString());
            return tag;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Ingredient Icon");
            builder.setDescription("Circles through the items of an ingredient.");
            builder.addProperty("ingredient", Ingredient.class).description("Ingredient for the item").required().exampleJson(Ingredient.m_204132_((TagKey)ItemTags.f_13161_).m_43942_());
        }
    }
}

