/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.GuiUtil;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;
import org.jetbrains.annotations.NotNull;

public record ItemInSlotIcon(PlayerSlot slot) implements IIcon
{
    @Override
    public void draw(Minecraft mc, GuiGraphics guiGraphics, DataContext context, int x, int y, int width, int height) {
        ItemStack found;
        PoseStack stack = guiGraphics.m_280168_();
        stack.m_85836_();
        stack.m_85837_((double)x + (double)width / 2.0, (double)y + (double)height / 2.0, 100.0);
        if (width != 16 || height != 16) {
            int s = Math.min(width, height);
            stack.m_85841_((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
        }
        ItemStack item = new ItemStack((ItemLike)Items.f_42127_);
        List<ItemStack> items = this.slot.getItems(context.getLivingEntity());
        if (!items.isEmpty() && !(found = items.get(0)).m_41619_()) {
            item = found;
        }
        GuiUtil.drawItem(guiGraphics, item, 0, true, null);
        stack.m_85849_();
    }

    public IconSerializer<ItemInSlotIcon> getSerializer() {
        return (IconSerializer)IconSerializers.ITEM_IN_SLOT.get();
    }

    @Override
    public String toString() {
        return "ItemIcon{slot=" + this.slot.toString() + "}";
    }

    public static class Serializer
    extends IconSerializer<ItemInSlotIcon> {
        @Override
        @NotNull
        public ItemInSlotIcon fromJSON(JsonObject json) {
            return new ItemInSlotIcon(PlayerSlot.get(GsonHelper.m_13906_((JsonObject)json, (String)"slot")));
        }

        @Override
        public ItemInSlotIcon fromNBT(CompoundTag nbt) {
            return new ItemInSlotIcon(PlayerSlot.get(nbt.m_128461_("Slot")));
        }

        @Override
        public JsonObject toJSON(ItemInSlotIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("slot", icon.slot.toString());
            return jsonObject;
        }

        @Override
        public CompoundTag toNBT(ItemInSlotIcon icon) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Slot", icon.slot.toString());
            return tag;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Item in Slot Icon");
            builder.setDescription("Uses the item that's in the specified slot.");
            builder.addProperty("slot", String.class).description("Name of the slot.").required().exampleJson((JsonElement)new JsonPrimitive("chest"));
        }
    }
}

