/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TexturedIcon
implements IIcon {
    public static final ResourceLocation LOCK = new ResourceLocation("palladium", "textures/icons/lock.png");
    public final TextureReference texture;
    public final Color tint;

    public TexturedIcon(TextureReference texture) {
        this(texture, null);
    }

    public TexturedIcon(TextureReference texture, Color tint) {
        this.texture = texture;
        this.tint = tint;
    }

    public TexturedIcon(ResourceLocation texture) {
        this(texture, null);
    }

    public TexturedIcon(ResourceLocation texture, Color tint) {
        this(TextureReference.normal(texture), tint);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(Minecraft mc, GuiGraphics guiGraphics, DataContext context, int x, int y, int w, int h) {
        PoseStack stack = guiGraphics.m_280168_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture.getTexture(context));
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        Matrix4f m = stack.m_85850_().m_252922_();
        Color color = this.tint != null ? this.tint : Color.WHITE;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        buffer.m_252986_(m, (float)x, (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, (float)(x + w), (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, (float)x, (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
    }

    public IconSerializer<TexturedIcon> getSerializer() {
        return (IconSerializer)IconSerializers.TEXTURE.get();
    }

    public String toString() {
        return "TexturedIcon{texture=" + String.valueOf(this.texture) + ", tint=" + String.valueOf(this.tint) + "}";
    }

    public static class Serializer
    extends IconSerializer<TexturedIcon> {
        @Override
        @NotNull
        public TexturedIcon fromJSON(JsonObject json) {
            TextureReference texture = TextureReference.parse(GsonHelper.m_13906_((JsonObject)json, (String)"texture"));
            Color tint = null;
            if (GsonHelper.m_13900_((JsonObject)json, (String)"tint")) {
                int[] color = GsonUtil.getIntArray(json, 3, "tint", 255, 255, 255);
                tint = new Color(color[0], color[1], color[2]);
            }
            return new TexturedIcon(texture, tint);
        }

        @Override
        public TexturedIcon fromNBT(CompoundTag nbt) {
            TextureReference texture = TextureReference.parse(nbt.m_128461_("Texture"));
            Color tint = null;
            if (nbt.m_128441_("ColorRed") && nbt.m_128441_("ColorGreen") && nbt.m_128441_("ColorBlue")) {
                tint = new Color(nbt.m_128451_("ColorRed"), nbt.m_128451_("ColorGreen"), nbt.m_128451_("ColorBlue"));
            }
            return new TexturedIcon(texture, tint);
        }

        @Override
        public JsonObject toJSON(TexturedIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("texture", icon.texture.toString());
            if (icon.tint != null) {
                JsonArray array = new JsonArray();
                array.add((Number)icon.tint.getRed());
                array.add((Number)icon.tint.getGreen());
                array.add((Number)icon.tint.getBlue());
                jsonObject.add("tint", (JsonElement)array);
            }
            return jsonObject;
        }

        @Override
        public CompoundTag toNBT(TexturedIcon icon) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Texture", icon.texture.toString());
            if (icon.tint != null) {
                nbt.m_128405_("ColorRed", icon.tint.getRed());
                nbt.m_128405_("ColorGreen", icon.tint.getGreen());
                nbt.m_128405_("ColorBlue", icon.tint.getBlue());
            }
            return nbt;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Textured Icon");
            builder.setDescription("Uses a texture to render as an icon.");
            builder.addProperty("texture", TextureReference.class).description("Path to the texture file or dynamic texture json file.").required().exampleJson((JsonElement)new JsonPrimitive("example:textures/icons/my_icon.png"));
            JsonArray tint = new JsonArray();
            tint.add((Number)123);
            tint.add((Number)32);
            tint.add((Number)212);
            builder.addProperty("tint", Integer[].class).description("Adds an additional tint to the texture.").fallback(new Integer[]{255, 255, 255}, "/").exampleJson((JsonElement)tint);
        }
    }
}

