/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ColorProperty
extends PalladiumProperty<Color> {
    public ColorProperty(String key) {
        super(key);
    }

    @Override
    public Color fromJSON(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return Color.decode(jsonElement.getAsString());
        }
        if (jsonElement.isJsonArray()) {
            JsonArray array = jsonElement.getAsJsonArray();
            if (array.size() == 3) {
                return new Color(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt());
            }
            if (array.size() == 4) {
                return new Color(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt(), array.get(3).getAsInt());
            }
            throw new JsonParseException("Color array must either have 3 (RGB) or 4 (RGBA) integers");
        }
        throw new JsonParseException("Color must either be defined as RGB-string or array of integers");
    }

    @Override
    public JsonElement toJSON(Color value) {
        if (value.getAlpha() != 255) {
            JsonArray array = new JsonArray();
            array.add((Number)value.getRed());
            array.add((Number)value.getGreen());
            array.add((Number)value.getBlue());
            array.add((Number)value.getAlpha());
            return array;
        }
        return new JsonPrimitive(String.format("#%02X%02X%02X", value.getRed(), value.getGreen(), value.getBlue()));
    }

    @Override
    public Color fromNBT(Tag tag, Color defaultValue) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return new Color(compoundTag.m_128451_("Red"), compoundTag.m_128451_("Green"), compoundTag.m_128451_("Blue"), compoundTag.m_128451_("Alpha"));
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(Color value) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Red", value.getRed());
        tag.m_128405_("Green", value.getGreen());
        tag.m_128405_("Blue", value.getBlue());
        tag.m_128405_("Alpha", value.getAlpha());
        return tag;
    }

    @Override
    public Color fromBuffer(FriendlyByteBuf buf) {
        return new Color(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        Color color = (Color)value;
        buf.writeInt(color.getRed());
        buf.writeInt(color.getGreen());
        buf.writeInt(color.getBlue());
        buf.writeInt(color.getAlpha());
    }

    @Override
    public String getPropertyType() {
        return "color";
    }
}

