/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.threetag.palladium.util.property.PalladiumProperty;

public class DoubleProperty
extends PalladiumProperty<Double> {
    public DoubleProperty(String key) {
        super(key);
    }

    @Override
    public Double fromJSON(JsonElement jsonElement) {
        return jsonElement.getAsDouble();
    }

    @Override
    public JsonElement toJSON(Double value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    public Double fromNBT(Tag tag, Double defaultValue) {
        if (tag instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)tag;
            return doubleTag.m_7061_();
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(Double value) {
        return DoubleTag.m_128500_((double)value);
    }

    @Override
    public Double fromBuffer(FriendlyByteBuf buf) {
        return buf.readDouble();
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        buf.writeDouble(((Double)value).doubleValue());
    }

    @Override
    public String getPropertyType() {
        return "double";
    }
}

