/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.threetag.palladium.entity.PalladiumEntityExtension;
import net.threetag.palladium.event.PalladiumEvents;
import net.threetag.palladium.network.SyncPropertyMessage;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import net.threetag.palladium.util.property.SyncType;

public class EntityPropertyHandler
extends PropertyManager
implements PropertyManager.Listener {
    final Entity entity;

    public EntityPropertyHandler(Entity entity) {
        this.entity = entity;
        this.setListener(this);
        ((PalladiumEvents.RegisterProperty)PalladiumEvents.REGISTER_PROPERTY.invoker()).register(this);
    }

    public Entity getEntity() {
        return this.entity;
    }

    public static Optional<EntityPropertyHandler> getHandler(Entity entity) {
        if (entity instanceof PalladiumEntityExtension) {
            PalladiumEntityExtension ext = (PalladiumEntityExtension)entity;
            return Optional.of(ext.palladium$getPropertyHandler());
        }
        return Optional.empty();
    }

    @Override
    public <T> void onChanged(PalladiumProperty<T> property, T oldValue, T newValue) {
        if (!(this.entity.m_9236_().f_46443_ || property instanceof BooleanProperty && oldValue == newValue)) {
            Entity entity;
            if (property.getSyncType() == SyncType.EVERYONE) {
                new SyncPropertyMessage(this.entity.m_19879_(), property, newValue).sendToDimension(this.entity.m_9236_());
            } else if (property.getSyncType() == SyncType.SELF && (entity = this.entity) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                new SyncPropertyMessage(this.entity.m_19879_(), property, newValue).send(serverPlayer);
            }
        }
    }
}

