/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.threetag.palladium.util.property.PalladiumProperty;

public abstract class EnumPalladiumProperty<T>
extends PalladiumProperty<T> {
    public EnumPalladiumProperty(String key) {
        super(key);
    }

    public abstract T[] getValues();

    public abstract String getNameFromEnum(T var1);

    public T getByName(String name) {
        for (T value : this.getValues()) {
            if (!this.getNameFromEnum(value).equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    @Override
    public String getDescription() {
        Object desc = super.getDescription();
        if (!((String)desc).endsWith(".")) {
            desc = (String)desc + ".";
        }
        return (String)desc + " Possible values: " + Arrays.toString(Arrays.stream(this.getValues()).map(this::getNameFromEnum).toList().toArray());
    }

    @Override
    public T fromJSON(JsonElement jsonElement) {
        T value = this.getByName(jsonElement.getAsString());
        if (value == null) {
            throw new JsonParseException("Unknown " + this.getKey() + " '" + jsonElement.getAsString() + "'");
        }
        return value;
    }

    @Override
    public JsonElement toJSON(T value) {
        return new JsonPrimitive(this.getNameFromEnum(value));
    }

    @Override
    public T fromNBT(Tag tag, T defaultValue) {
        StringTag stringTag;
        T value;
        if (tag instanceof StringTag && (value = this.getByName((stringTag = (StringTag)tag).m_7916_())) != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(T value) {
        return StringTag.m_129297_((String)this.getNameFromEnum(value));
    }

    @Override
    public T fromBuffer(FriendlyByteBuf buf) {
        return this.getByName(buf.m_130277_());
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        buf.m_130070_(this.getNameFromEnum(value));
    }
}

