/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.threetag.palladium.util.property.AttributeProperty;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.ColorProperty;
import net.threetag.palladium.util.property.ComponentProperty;
import net.threetag.palladium.util.property.CompoundTagProperty;
import net.threetag.palladium.util.property.DoubleProperty;
import net.threetag.palladium.util.property.EnchantmentProperty;
import net.threetag.palladium.util.property.EntityTypeProperty;
import net.threetag.palladium.util.property.EquipmentSlotProperty;
import net.threetag.palladium.util.property.FloatArrayProperty;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.IconProperty;
import net.threetag.palladium.util.property.IngredientProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.ItemProperty;
import net.threetag.palladium.util.property.MobEffectProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PoseProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;
import net.threetag.palladium.util.property.StringArrayProperty;
import net.threetag.palladium.util.property.StringProperty;
import net.threetag.palladium.util.property.SuitSetPropertyPalladium;
import net.threetag.palladium.util.property.UUIDProperty;

public class PalladiumPropertyLookup {
    private static final Map<String, Function<String, PalladiumProperty<?>>> PROPERTIES = new HashMap();

    public static void register(String typeName, Function<String, PalladiumProperty<?>> function) {
        PROPERTIES.put(typeName, function);
    }

    public static PalladiumProperty<?> get(String type, String key) {
        return PROPERTIES.containsKey(type) ? PROPERTIES.get(type).apply(key) : null;
    }

    static {
        PalladiumPropertyLookup.register("integer", IntegerProperty::new);
        PalladiumPropertyLookup.register("float", FloatProperty::new);
        PalladiumPropertyLookup.register("double", DoubleProperty::new);
        PalladiumPropertyLookup.register("boolean", BooleanProperty::new);
        PalladiumPropertyLookup.register("string", StringProperty::new);
        PalladiumPropertyLookup.register("resource_location", ResourceLocationProperty::new);
        PalladiumPropertyLookup.register("color", ColorProperty::new);
        PalladiumPropertyLookup.register("attribute", AttributeProperty::new);
        PalladiumPropertyLookup.register("component", ComponentProperty::new);
        PalladiumPropertyLookup.register("compound_tag", CompoundTagProperty::new);
        PalladiumPropertyLookup.register("enchantment", EnchantmentProperty::new);
        PalladiumPropertyLookup.register("entity_type", EntityTypeProperty::new);
        PalladiumPropertyLookup.register("icon", IconProperty::new);
        PalladiumPropertyLookup.register("item", ItemProperty::new);
        PalladiumPropertyLookup.register("mob_effect", MobEffectProperty::new);
        PalladiumPropertyLookup.register("pose", PoseProperty::new);
        PalladiumPropertyLookup.register("string_array", StringArrayProperty::new);
        PalladiumPropertyLookup.register("float_array", FloatArrayProperty::new);
        PalladiumPropertyLookup.register("suit_set", SuitSetPropertyPalladium::new);
        PalladiumPropertyLookup.register("uuid", UUIDProperty::new);
        PalladiumPropertyLookup.register("equipment_slot", EquipmentSlotProperty::new);
        PalladiumPropertyLookup.register("ingredient", IngredientProperty::new);
    }
}

