/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladiumcore.registry.PalladiumRegistry;

public class PalladiumRegistryObjectProperty<T>
extends PalladiumProperty<T> {
    private final PalladiumRegistry<T> registry;

    public PalladiumRegistryObjectProperty(String key, PalladiumRegistry<T> registry) {
        super(key);
        this.registry = registry;
    }

    @Override
    public T fromJSON(JsonElement jsonElement) {
        ResourceLocation id = new ResourceLocation(jsonElement.getAsString());
        if (this.registry.get(id) != null) {
            return (T)this.registry.get(id);
        }
        throw new JsonParseException("Unknown " + this.registry.getRegistryKey().m_135782_().toString() + " '" + String.valueOf(id) + "'");
    }

    @Override
    public JsonElement toJSON(T value) {
        return new JsonPrimitive(Objects.requireNonNull(this.registry.getKey(value)).toString());
    }

    @Override
    public T fromNBT(Tag tag, T defaultValue) {
        StringTag stringTag;
        ResourceLocation id;
        if (tag instanceof StringTag && this.registry.get(id = new ResourceLocation((stringTag = (StringTag)tag).m_7916_())) != null) {
            return (T)this.registry.get(id);
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(T value) {
        return StringTag.m_129297_((String)Objects.requireNonNull(this.registry.getKey(value)).toString());
    }

    @Override
    public T fromBuffer(FriendlyByteBuf buf) {
        return (T)this.registry.get(buf.m_130281_());
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        buf.m_130085_(Objects.requireNonNull(this.registry.getKey(value)));
    }

    @Override
    public String getString(T value) {
        return value != null ? Objects.requireNonNull(this.registry.getKey(value)).toString() : null;
    }
}

