/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EquipmentSlot;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.property.PalladiumProperty;

public class PlayerSlotListProperty
extends PalladiumProperty<List<PlayerSlot>> {
    public PlayerSlotListProperty(String key) {
        super(key);
    }

    @Override
    public List<PlayerSlot> fromJSON(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return Collections.singletonList(PlayerSlot.get(jsonElement.getAsString()));
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        ArrayList<PlayerSlot> list = new ArrayList<PlayerSlot>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add(PlayerSlot.get(jsonArray.get(i).getAsString()));
        }
        return list;
    }

    @Override
    public JsonElement toJSON(List<PlayerSlot> value) {
        JsonArray jsonArray = new JsonArray();
        for (PlayerSlot s : value) {
            jsonArray.add(s.toString());
        }
        return jsonArray;
    }

    @Override
    public List<PlayerSlot> fromNBT(Tag tag, List<PlayerSlot> defaultValue) {
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            ArrayList<PlayerSlot> list = new ArrayList<PlayerSlot>();
            for (int i = 0; i < listTag.size(); ++i) {
                list.add(PlayerSlot.get(listTag.m_128778_(i)));
            }
            return list;
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(List<PlayerSlot> value) {
        ListTag listTag = new ListTag();
        for (PlayerSlot s : value) {
            listTag.add((Object)StringTag.m_129297_((String)s.toString()));
        }
        return listTag;
    }

    @Override
    public List<PlayerSlot> fromBuffer(FriendlyByteBuf buf) {
        ArrayList<PlayerSlot> list = new ArrayList<PlayerSlot>();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            list.add(PlayerSlot.get(buf.m_130277_()));
        }
        return list;
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        List strings = (List)value;
        buf.writeInt(strings.size());
        for (PlayerSlot slot : strings) {
            buf.m_130070_(slot.toString());
        }
    }

    @Override
    public String getString(List<PlayerSlot> value) {
        return value == null ? null : Arrays.toString(value.toArray());
    }

    @Override
    public String getDescription() {
        Object desc = super.getDescription();
        if (!((String)desc).endsWith(".")) {
            desc = (String)desc + ".";
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.stream(EquipmentSlot.values()).map(EquipmentSlot::m_20751_).toList());
        list.add("curios:back");
        list.add("curios:necklace");
        list.add("trinkets:chest/back");
        list.add("trinkets:chest/necklace");
        return (String)desc + " Example values: " + Arrays.toString(list.toArray());
    }
}

