/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.util.property.PalladiumProperty;
import org.jetbrains.annotations.Nullable;

public class PropertyManager {
    final Map<PalladiumProperty<?>, Object> defaultProperties = new LinkedHashMap();
    final Map<PalladiumProperty<?>, Object> values = new LinkedHashMap();
    Listener listener;

    public PropertyManager setListener(Listener listener) {
        this.listener = listener;
        return this;
    }

    public <T> PropertyManager register(PalladiumProperty<T> property, T value) {
        this.defaultProperties.put(property, value);
        this.values.put(property, value);
        return this;
    }

    public boolean isRegistered(PalladiumProperty<?> property) {
        return this.defaultProperties.containsKey(property);
    }

    public <T> PropertyManager set(PalladiumProperty<T> property, @Nullable T value) {
        if (!this.defaultProperties.containsKey(property)) {
            throw new RuntimeException("Property " + property.getKey() + " was not registered!");
        }
        Object oldValue = this.values.get(property);
        this.values.put(property, value);
        if (this.listener != null) {
            this.listener.onChanged(property, oldValue, value);
        }
        return this;
    }

    public PropertyManager setRaw(PalladiumProperty property, @Nullable Object value) {
        if (!this.defaultProperties.containsKey(property)) {
            throw new RuntimeException("Property " + property.getKey() + " was not registered!");
        }
        Object oldValue = this.values.get(property);
        this.values.put(property, value);
        if (this.listener != null) {
            this.listener.onChanged(property, oldValue, value);
        }
        return this;
    }

    @Nullable
    public <T> T get(PalladiumProperty<T> property) {
        return (T)this.values.get(property);
    }

    @Nullable
    public <T> T getDefault(PalladiumProperty<T> property) {
        return (T)this.defaultProperties.get(property);
    }

    public <T> Optional<T> optional(PalladiumProperty<T> property) {
        return Optional.ofNullable(this.get(property));
    }

    public <T> T reset(PalladiumProperty<T> property) {
        Object oldValue = this.values.get(property);
        Object defVal = this.defaultProperties.get(property);
        this.values.put(property, defVal);
        if (this.listener != null) {
            this.listener.onChanged(property, oldValue, defVal);
        }
        return (T)this.defaultProperties.get(property);
    }

    public PalladiumProperty<?> getPropertyByName(String name) {
        for (PalladiumProperty<?> property : this.values.keySet()) {
            if (!property.getKey().equals(name)) continue;
            return property;
        }
        return null;
    }

    public Map<PalladiumProperty<?>, Object> values() {
        return this.values;
    }

    public PropertyManager copy() {
        PropertyManager propertyManager = new PropertyManager();
        propertyManager.defaultProperties.putAll(this.defaultProperties);
        propertyManager.values.putAll(this.values);
        return propertyManager;
    }

    public void fromNBT(CompoundTag nbt) {
        this.values.clear();
        for (PalladiumProperty<?> property : this.defaultProperties.keySet()) {
            if (nbt.m_128441_(property.getKey())) {
                StringTag stringTag;
                Tag tag = nbt.m_128423_(property.getKey());
                if (tag instanceof StringTag && (stringTag = (StringTag)tag).m_7916_().equals("null")) {
                    this.values.put(property, null);
                    continue;
                }
                this.values.put(property, property.fromNBT(nbt.m_128423_(property.getKey()), this.defaultProperties.get(property)));
                continue;
            }
            this.values.put(property, property.fromNBT(nbt.m_128423_(property.getKey()), this.defaultProperties.get(property)));
        }
    }

    public CompoundTag toNBT(boolean toDisk) {
        CompoundTag nbt = new CompoundTag();
        for (PalladiumProperty<?> property : this.values.keySet()) {
            if (toDisk && !property.isPersistent()) continue;
            if (this.values.get(property) == null) {
                nbt.m_128365_(property.getKey(), (Tag)StringTag.m_129297_((String)"null"));
                continue;
            }
            nbt.m_128365_(property.getKey(), property.toNBT(this.values.get(property)));
        }
        return nbt;
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.writeInt(this.values.size());
        this.values.forEach((property, value) -> {
            buf.m_130070_(property.getKey());
            buf.writeBoolean(value != null);
            if (value != null) {
                property.toBuffer(buf, value);
            }
        });
    }

    public void fromBuffer(FriendlyByteBuf buf) {
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            PalladiumProperty<?> property = this.getPropertyByName(buf.m_130277_());
            if (!buf.readBoolean() || property == null) continue;
            this.values.put(property, property.fromBuffer(buf));
        }
    }

    public void fromJSON(JsonObject json) {
        for (PalladiumProperty<?> property : this.defaultProperties.keySet()) {
            if (!GsonHelper.m_13900_((JsonObject)json, (String)property.getKey())) continue;
            JsonElement jsonElement = json.get(property.getKey());
            if (jsonElement.isJsonPrimitive() && jsonElement.getAsString().equals("null")) {
                this.values.put(property, null);
                continue;
            }
            this.values.put(property, property.fromJSON(json.get(property.getKey())));
        }
    }

    public static interface Listener {
        public <T> void onChanged(PalladiumProperty<T> var1, T var2, T var3);
    }
}

