/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ResourceLocationListProperty
extends PalladiumProperty<List<ResourceLocation>> {
    public ResourceLocationListProperty(String key) {
        super(key);
    }

    @Override
    public List<ResourceLocation> fromJSON(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return Collections.singletonList(new ResourceLocation(jsonElement.getAsString()));
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            resourceLocations.add(new ResourceLocation(jsonArray.get(i).getAsString()));
        }
        return resourceLocations;
    }

    @Override
    public JsonElement toJSON(List<ResourceLocation> value) {
        if (value.size() == 1) {
            return new JsonPrimitive(value.toString());
        }
        JsonArray jsonArray = new JsonArray();
        for (ResourceLocation rl : value) {
            jsonArray.add(rl.toString());
        }
        return jsonArray;
    }

    @Override
    public List<ResourceLocation> fromNBT(Tag tag, List<ResourceLocation> defaultValue) {
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            for (int i = 0; i < listTag.size(); ++i) {
                list.add(new ResourceLocation(listTag.m_128778_(i)));
            }
            return list;
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(List<ResourceLocation> value) {
        ListTag listTag = new ListTag();
        for (ResourceLocation s : value) {
            listTag.add((Object)StringTag.m_129297_((String)s.toString()));
        }
        return listTag;
    }

    @Override
    public List<ResourceLocation> fromBuffer(FriendlyByteBuf buf) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            list.add(buf.m_130281_());
        }
        return list;
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        List strings = (List)value;
        buf.writeInt(strings.size());
        for (ResourceLocation resourceLocation : strings) {
            buf.m_130085_(resourceLocation);
        }
    }

    @Override
    public String getString(List<ResourceLocation> value) {
        return value == null ? null : Arrays.toString(value.stream().map(ResourceLocation::toString).toList().toArray());
    }
}

