/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ResourceLocationProperty
extends PalladiumProperty<ResourceLocation> {
    public ResourceLocationProperty(String key) {
        super(key);
    }

    @Override
    public ResourceLocation fromJSON(JsonElement jsonElement) {
        return new ResourceLocation(jsonElement.getAsString());
    }

    @Override
    public JsonElement toJSON(ResourceLocation value) {
        return new JsonPrimitive(value.toString());
    }

    @Override
    public ResourceLocation fromNBT(Tag tag, ResourceLocation defaultValue) {
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return new ResourceLocation(stringTag.m_7916_());
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(ResourceLocation value) {
        return StringTag.m_129297_((String)value.toString());
    }

    @Override
    public ResourceLocation fromBuffer(FriendlyByteBuf buf) {
        return buf.m_130281_();
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        buf.m_130085_((ResourceLocation)value);
    }

    @Override
    public String getPropertyType() {
        return "resource_location";
    }
}

