/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladium.util.property.PalladiumProperty;

public class SkinTypedResourceLocationProperty
extends PalladiumProperty<SkinTypedValue<ResourceLocation>> {
    public SkinTypedResourceLocationProperty(String key) {
        super(key);
    }

    @Override
    public SkinTypedValue<ResourceLocation> fromJSON(JsonElement jsonElement) {
        return SkinTypedValue.fromJSON(jsonElement, element -> GsonUtil.convertToResourceLocation(element, this.getKey()));
    }

    @Override
    public JsonElement toJSON(SkinTypedValue<ResourceLocation> value) {
        return value.toJson(resourceLocation -> new JsonPrimitive(resourceLocation.toString()));
    }

    @Override
    public SkinTypedValue<ResourceLocation> fromNBT(Tag tag, SkinTypedValue<ResourceLocation> defaultValue) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return new SkinTypedValue<ResourceLocation>(new ResourceLocation(compoundTag.m_128461_("Normal"), compoundTag.m_128461_("Slim")));
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(SkinTypedValue<ResourceLocation> value) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Normal", value.getNormal().toString());
        tag.m_128359_("Slim", value.getSlim().toString());
        return tag;
    }

    @Override
    public SkinTypedValue<ResourceLocation> fromBuffer(FriendlyByteBuf buf) {
        return new SkinTypedValue<ResourceLocation>(buf.m_130281_(), buf.m_130281_());
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        SkinTypedValue val = (SkinTypedValue)value;
        buf.m_130085_((ResourceLocation)val.getNormal());
        buf.m_130085_((ResourceLocation)val.getSlim());
    }
}

