/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladium.util.property.PalladiumProperty;

public class SkinTypedTextureReferenceProperty
extends PalladiumProperty<SkinTypedValue<TextureReference>> {
    public SkinTypedTextureReferenceProperty(String key) {
        super(key);
    }

    @Override
    public SkinTypedValue<TextureReference> fromJSON(JsonElement jsonElement) {
        return SkinTypedValue.fromJSON(jsonElement, element -> GsonUtil.convertToTextureReference(element, this.getKey()));
    }

    @Override
    public JsonElement toJSON(SkinTypedValue<TextureReference> value) {
        return value.toJson(textureReference -> new JsonPrimitive(textureReference.toString()));
    }

    @Override
    public SkinTypedValue<TextureReference> fromNBT(Tag tag, SkinTypedValue<TextureReference> defaultValue) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return new SkinTypedValue<TextureReference>(TextureReference.parse(compoundTag.m_128461_("Normal")), TextureReference.parse(compoundTag.m_128461_("Slim")));
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(SkinTypedValue<TextureReference> value) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Normal", value.getNormal().toString());
        tag.m_128359_("Slim", value.getSlim().toString());
        return tag;
    }

    @Override
    public SkinTypedValue<TextureReference> fromBuffer(FriendlyByteBuf buf) {
        return new SkinTypedValue<TextureReference>(TextureReference.fromBuffer(buf), TextureReference.fromBuffer(buf));
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        SkinTypedValue val = (SkinTypedValue)value;
        ((TextureReference)val.getNormal()).toBuffer(buf);
        ((TextureReference)val.getSlim()).toBuffer(buf);
    }
}

