/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.core.Registry;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.threetag.palladium.util.property.PalladiumProperty;

public class TagKeyProperty<T>
extends PalladiumProperty<TagKey<T>> {
    private final ResourceKey<Registry<T>> registry;

    public TagKeyProperty(String key, ResourceKey<Registry<T>> registry) {
        super(key);
        this.registry = registry;
    }

    @Override
    public TagKey<T> fromJSON(JsonElement jsonElement) {
        return TagKey.m_203882_(this.registry, (ResourceLocation)new ResourceLocation(jsonElement.getAsString()));
    }

    @Override
    public JsonElement toJSON(TagKey<T> value) {
        return new JsonPrimitive(value.f_203868_().toString());
    }

    @Override
    public TagKey<T> fromNBT(Tag tag, TagKey<T> defaultValue) {
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return TagKey.m_203882_(this.registry, (ResourceLocation)new ResourceLocation(stringTag.m_7916_()));
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(TagKey<T> value) {
        return StringTag.m_129297_((String)value.f_203868_().toString());
    }

    @Override
    public TagKey<T> fromBuffer(FriendlyByteBuf buf) {
        return TagKey.m_203882_(this.registry, (ResourceLocation)buf.m_130281_());
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        buf.m_130085_(((TagKey)value).f_203868_());
    }

    @Override
    public String getString(TagKey<T> value) {
        return value == null ? null : value.f_203868_().toString();
    }

    @Override
    public String getPropertyType() {
        return this.registry.m_135782_().m_135815_() + "_tag";
    }
}

